﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace BenkyouStudio
{  
    public partial class frmInstantForm : Form
    {
        private InstantForm ifrm;
        public event InstantFormEventOccured EventOccured;
        public double opacity2 = 0;
        public frmInstantForm(string filename)
        {
            ifrm = new InstantForm(this,false);
            ifrm.EventOccured += new InstantFormEventOccured(DoTextCommand);
            System.IO.StreamReader sr = new System.IO.StreamReader(filename);
            while (sr.Peek() >= 0)
            {
                string Lin = sr.ReadLine();
                string splitter = core.GetSplitter(Lin);
                String FileVer = ss.GetItem(Lin, splitter, 1);
                //if (FileVer.Equals("DEF-V1")) { core.settemplate(ss.GetItem(Lin, splitter, 2), Lin, true); };
                //if (FileVer.Equals("INI-V1")) { core.SetIniVal(core.GetVar(Lin, "inivar"), core.GetVar(Lin, "inival"), VbX.CBool(core.GetVar(Lin, "ramvar"))); }
                if (FileVer.Equals("FRM-V1")) { ifrm.fromstring(Lin); } else  core.ReadWordLine(Lin, -1, true, ref sr);
            }
            sr.Close();
            ifrm.GroupSizerRefresh();
            if (ifrm.formthemed == false)
            {
              ui.ThemeUi(this);
                ui.ThemeMenu(ifrm.menuStrip);
            }
            opacity2 = this.Opacity;
            this.Opacity=0;
            this.Shown += new EventHandler(this.FormShown);
            this.FormClosing += new System.Windows.Forms.FormClosingEventHandler(this.FormClosingevt);
        }
        public void FormShown(object sender, EventArgs e)
        {
            ((Form)sender).Opacity = 0;
            double op = opacity2;
            ui.FadeIn(((Form)sender), op);
        }
        public void FormClosingevt(object sender, FormClosingEventArgs e)
        {
            ui.FadeOut(this, this.Opacity);
            foreach (Control c in ifrm.RootControl.Controls)
            {
                if (c.GetType() == typeof(GroupBox)) {
                    string val = "0";
                    if (c.Height <= 32) val = "1";
                    core.SetIniVal("GroupMin_"+c.Text,val);
                }
            }
        }
        public bool DoTextCommand(InstantForm sender,string lin)
        {
            // see if we should use a special handler
            if (VbX.Left(lin,4)=="FRM_"){
                if (System.IO.File.Exists(VbX.Right(lin, VbX.Len(lin) - 4))) new frmInstantForm(VbX.Right(lin, VbX.Len(lin) - 4)).Show();
                else VbX.MsgBox("Cant find Form File '" + VbX.Right(lin, VbX.Len(lin) - 4) + "'");
                return true;
            }
            if (VbX.Left(lin, 4) == "APP_")
            {
                    System.Diagnostics.Process.Start(VbX.Right(lin, VbX.Len(lin) - 4));
                return true;
            }
            
            if (lin.ToLower() == "formsaveandclose") { 
                SaveAndClose(ifrm.RootControl,true);
            }
            if (lin.ToLower() == "formsaveiniandclose")
            {
                SaveAndClose(ifrm.RootControl, false);
                core.savescores(core.WordFile);
                clsTextCommand.DoTextCommand(null, "reloadglobals");
            }
            else if (lin.ToLower() == "formclose")
            {
                this.Close();
            }
            if (clsTextCommand.DoTextCommand(sender,lin)==true) return true;
            if (EventOccured != null) if (EventOccured(sender,lin) == true) return true;
            return false;
        }
        
        public void SaveAndClose(Control mainpnl,bool ramonly)
        {
            foreach (Control c in mainpnl.Controls)
            {
                if (VbX.Left(c.Name, 4).ToLower() == "ini_") core.SetIniVal(VbX.Right(c.Name, c.Name.Length - 4), ifrm.GetVar(ifrm.RootControl,c.Name,""),ramonly);
                if (c.HasChildren) SaveAndClose(c,ramonly);
            }
            
            this.Close();
        }
    }
} 
