﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BenkyouStudio
{
    public class ui
    {
        public static System.Drawing.Color mycolor(String lin)
        {
            if (lin.Equals("red")) return System.Drawing.Color.FromArgb(255, 255, 200, 200);
            return System.Drawing.Color.FromArgb(255, 200, 255, 200);

        }
        public static System.Drawing.Color ColorNum(int i, System.Windows.Forms.Control ctr)
        {
            if ((core.UiTheme == "" || core.UiTheme == "default") && i==0){
                if (ctr.GetType() == typeof(System.Windows.Forms.TextBox)) return System.Drawing.SystemColors.Window;
                if (ctr.GetType() == typeof(System.Windows.Forms.ListBox)) return System.Drawing.SystemColors.Window;
                //if (ctr.GetType() == typeof(System.Windows.Forms.RichTextBox)) return System.Drawing.SystemColors.Window;
            }
            
            return ColorNum(i); 
        }
                
        public static System.Drawing.Color ColorNum(int i)
        {
            if (core.UiSequence <= 0 || i != -1)
            {
                if (i == -1) i = VbX.CInt(VbX.Rnd() * 6) + 1;
            }
            else
            {
                i = core.UiSequence;
                core.UiSequence++;
                if (core.UiSequence == 7) core.UiSequence = 1;
            }
            if (core.UiTheme == "" || core.UiTheme == "default")
            {
                switch (i)
                {
                    case -2:
                    case 0: return System.Drawing.SystemColors.ButtonFace;
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 5:
                    case 6: return System.Drawing.SystemColors.ControlText;
                }
            }
            if (core.UiTheme == "shadow")
            {
                switch (i)
                {
                    case -2:
                    case 0: return System.Drawing.Color.FromArgb(255, 64, 64, 64);
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 5:
                    case 6: return System.Drawing.Color.FromArgb(255, 200, 200, 200);
                }

            }
            if (core.UiTheme == "spectrum")
            {

                switch (i)
                {
                    case -2: return System.Drawing.Color.FromArgb(255, 48, 48, 48);
                    case 0: return System.Drawing.Color.Black;
                    case 1: return System.Drawing.Color.Magenta;
                    case 2: return System.Drawing.Color.Yellow;
                    case 3: return System.Drawing.Color.Cyan;
                    case 4: return System.Drawing.Color.Red;
                    case 5: return System.Drawing.Color.Lime;
                    case 6: return System.Drawing.Color.DeepSkyBlue;
                }

            }
            if (core.UiTheme == "ember")
            {

                switch (i)
                {
                    case -2:
                    case 0: return System.Drawing.Color.FromArgb(255, 48, 48, 48);
                    case 1: return System.Drawing.Color.FromArgb(255, 192, 0, 0);
                    case 2: return System.Drawing.Color.FromArgb(255, 255, 0, 0);
                    case 3: return System.Drawing.Color.FromArgb(255, 255, 64, 0);
                    case 4: return System.Drawing.Color.FromArgb(255, 255, 128, 0);
                    case 5: return System.Drawing.Color.FromArgb(255, 255, 192, 0);
                    case 6: return System.Drawing.Color.FromArgb(255, 255, 255, 0);

                };

            }
            if (core.UiTheme == "highvis" || core.UiTheme == "whiteout")
            {

                int high = 255;
                int low = 0;
                if (core.UiTheme == "highvis")
                {
                    if (i == 0) return System.Drawing.Color.Black;
                    if (i == -2) return System.Drawing.Color.FromArgb(255, 48, 48, 48);
                    high = 255;
                    low = 200;
                }
                if (core.UiTheme == "whiteout")
                {
                    if (i == 0) return System.Drawing.Color.White;
                    if (i == -2) return System.Drawing.Color.White;
                    high = 95;
                    low = 0;
                }
                switch (i)
                {
                    case -2:
                    case 1: return System.Drawing.Color.FromArgb(255, high, low, low);
                    case 2: return System.Drawing.Color.FromArgb(255, low, high, low);
                    case 3: return System.Drawing.Color.FromArgb(255, low, low, high);
                    case 4: return System.Drawing.Color.FromArgb(255, high, high, low);
                    case 5: return System.Drawing.Color.FromArgb(255, high, low, high);
                    case 6: return System.Drawing.Color.FromArgb(255, low, high, high);
                }
            }
            return System.Drawing.Color.White;
        }
    
     
        public static void ThemeMenu(System.Windows.Forms.MenuStrip mainpnl)
        {

            if (core.UiTheme == "" || core.UiTheme == "default") return;
            if (mainpnl == null) return;
            foreach (System.Windows.Forms.ToolStripMenuItem c in mainpnl.Items)
            {
                c.ForeColor = ColorNum(-1);
                c.BackColor = ColorNum(0);

                if (c.HasDropDownItems) ThemeMenu(c);
            }
        }
        public static void ThemeMenu(System.Windows.Forms.ToolStripMenuItem mainpnl)
        {
            foreach (System.Windows.Forms.ToolStripMenuItem c in mainpnl.DropDownItems)
            {
                c.ForeColor = ColorNum(-1);
                c.BackColor = ColorNum(-2);
             //   LangMenu(c);
                if (c.HasDropDownItems) ThemeMenu(c);
            }
        }
        /*
        public static void LangMenu(System.Windows.Forms.ToolStripMenuItem c)
        {
            if (!System.IO.File.Exists("res\\mlui\\" + core.UiLangPack)) return;

            string namematch = "";
            string textmatch = "";
            System.IO.StreamReader sr = new System.IO.StreamReader("res\\mlui\\" + core.UiLangPack);
            while (sr.Peek() >= 0)
            {
                string Lin = sr.ReadLine();
                string splitter = core.GetSplitter(Lin);
                String FileVer = ss.GetItem(Lin, splitter, 1);
                //if (FileVer.Equals("DEF-V1")) { core.settemplate(ss.GetItem(Lin, splitter, 2), Lin,true); }
                if (FileVer.Equals("MLI-V1"))
                {
                    string tname = core.GetVar(Lin, "name");
                    string ttext = core.GetVar(Lin, "text");
                    if (c.Text.ToLower() == ttext.ToLower() && ttext != "") textmatch = core.GetVar(Lin, "string");
                    if (c.Name.ToLower() == tname.ToLower() && tname != "") namematch = core.GetVar(Lin, "string");
                } else core.ReadWordLine(Lin, -1, true, sr);
            }
            sr.Close();
            namematch = namematch.Replace("<br>", " ");
            textmatch = textmatch.Replace("<br>", " ");
            if (namematch != "") c.Text = namematch;
            else if (textmatch != "") c.Text = textmatch;
        }
      */ 
        public static void ThemeButton(System.Windows.Forms.Button btn)
        {
            if (core.UiTheme == "spectrum" || core.UiTheme == "highvis")
            {
                btn.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
            }

            if (btn.Image == null) return;
            System.Drawing.Graphics g = System.Drawing.Graphics.FromImage(btn.Image);
            System.Drawing.Bitmap b = (System.Drawing.Bitmap)btn.Image;
            for (int x = 0; x < b.Width; x++)
                for (int y = 0; y < b.Width; y++)
                {
                    System.Drawing.Color p2 = b.GetPixel(x, y);
                    System.Drawing.Color p = p2;
                    int A = p2.A;
                    int R = p2.R;
                    int G = p2.G;
                    int B = p2.B;

                    if (core.rangelimit(core.GetIniVal("ThemeUI_IconInvert", ""), "1", "0").Equals("1"))
                    {
                        R = 255 - R; G = 255 - G; B = 255 - B;
                    }
                    if (core.UiTheme == "highvis")
                    {
                        R = ((R + G + B + 255 * 3) / 6);
                        G = R; B = R;
                        p = System.Drawing.Color.FromArgb(A, btn.ForeColor.R * R / 255, btn.ForeColor.G * G / 255, btn.ForeColor.B * B / 255);
                    }

                    if (core.UiTheme == "whiteout")
                    {

                        R = ((R + G + B) / 3);
                        if (A > 64) A = R;
                        G = R; B = R;
                        p = System.Drawing.Color.FromArgb(A, btn.ForeColor.R * R / 255, btn.ForeColor.G * G / 255, btn.ForeColor.B * B / 255);
                    }

                    if (core.UiTheme == "shadow")
                    {

                        R = ((R + G + B) / 3);
                        if (R > 64) A /= 2;
                        G = R; B = R;
                        p = System.Drawing.Color.FromArgb(A, R, G, B);
                    }
                    if (core.UiTheme == "ember")
                    {
                        p = System.Drawing.Color.FromArgb(A, btn.ForeColor.R * R / 255, btn.ForeColor.G * G / 255, btn.ForeColor.B * B / 255);
                    };
                    if (core.UiTheme == "spectrum")
                    {
                        R = ((R + G + B + 255 * 3) / 6);
                        G = R; B = R;
                        p = System.Drawing.Color.FromArgb(A, btn.ForeColor.R * R / 255, btn.ForeColor.G * G / 255, btn.ForeColor.B * B / 255);
                    }

                    b.SetPixel(x, y, p);
                }
            btn.Image = (System.Drawing.Image)b;


        }
        public static void ThemeUi(System.Windows.Forms.Form th)
        {
            VbX.Randomize();
            th.BackColor = ColorNum(0);

            th.Opacity = core.rangelimit(core.GetIniVal("UiOpacity", "1"), .5, 1, 0);

            //if (core.highvis == 2) { th.BackColor = System.Drawing.Color.White; }
            //else { th.BackColor = System.Drawing.Color.Black; }
            foreach (System.Windows.Forms.Control ctr in th.Controls)
            {
                ctr.ForeColor = ColorNum(-1);
                ctr.BackColor = ColorNum(0, ctr);
                if (ctr.GetType() == typeof(System.Windows.Forms.Button)) ThemeButton((System.Windows.Forms.Button)ctr);
                if (ctr.GetType() == typeof(System.Windows.Forms.Button)) LangUI(ctr);
                if (ctr.GetType() == typeof(System.Windows.Forms.Label)) LangUI(ctr);
                if (ctr.GetType() == typeof(System.Windows.Forms.GroupBox)) LangUI(ctr);
                if (ctr.HasChildren) ThemeChildren(ctr);

            }
        }
        public static void ThemeChildren(System.Windows.Forms.Control ctr)
        {
            if (ctr.Name.ToLower() != "hr") ctr.BackColor = ColorNum(0, ctr);
            foreach (System.Windows.Forms.Control ctr2 in ctr.Controls)
            {
                if (ctr2.Name.ToLower() != "hr")
                {
                    ctr2.ForeColor = ColorNum(-1);
                    ctr2.BackColor = ColorNum(0, ctr2);
                    //core.colorlabel(ctr2);
                    if (ctr2.GetType() == typeof(System.Windows.Forms.Button)) ThemeButton((System.Windows.Forms.Button)ctr2);
                    if (ctr2.GetType() == typeof(System.Windows.Forms.Button)) LangUI(ctr2);
                    if (ctr2.GetType() == typeof(System.Windows.Forms.Label)) LangUI(ctr2);
                    if (ctr2.GetType() == typeof(System.Windows.Forms.GroupBox)) LangUI(ctr2);
                    if (ctr2.GetType() == typeof(System.Windows.Forms.TabControl)) LangUI(ctr2);
                    if (ctr2.HasChildren) ThemeChildren(ctr2);
                }
            }

        }
        public static void LangUI(System.Windows.Forms.Control c)
        {
            c.Text = GetTrans(c.Name, c.Text,true);
         
        }
        public static string brfix(string lin, bool allowbr) {
            if (allowbr)   lin = lin.Replace("<br>", Environment.NewLine);
            else  lin = lin.Replace("<br>", " ");
            return lin;
        }
        public static void FadeIn(System.Windows.Forms.Form form,double op) {

            for (double i = 0; i < op; i += .1) { form.Opacity = i;
            form.Refresh();
                System.Threading.Thread.Sleep(20); }
            form.Opacity = op;
        }
        public static void FadeOut(System.Windows.Forms.Form form, double op)
        {

            for (double i = op; i > 0; i -= .05) { form.Opacity = i;
                form.Refresh();
                System.Threading.Thread.Sleep(20); }
           
        }
     public static string GetTrans(string name,string defaulttext,bool allowbr)
        {
            string UiLangPack = core.GetIniVal("UiLangPack", "");

            if (!System.IO.File.Exists("res\\mlui\\" + UiLangPack)) return defaulttext ;
           
            String FileTemp=""; 
            string namematch = "";
            string textmatch = "";

            
            System.IO.StreamReader sr = new System.IO.StreamReader("res\\mlui\\" +UiLangPack);
            while (sr.Peek() >= 0)
            {
                
                string Lin = sr.ReadLine();
              

                string splitter = core.GetSplitter(Lin);
                string FileVer = ss.GetItem(Lin, splitter, 1);
                

                
                //if (FileVer.Equals("DEF-V1")) { core.settemplate(ss.GetItem(Lin, splitter, 2), Lin,true); }
                if (FileVer.Equals("MLI-V1"))
                {
                    if (FileTemp=="") FileTemp = ss.GetItem(Lin, splitter, 2);
                    string tname = core.GetVar(Lin, "name");
                    string ttext = core.GetVar(Lin, "text");
                    if (defaulttext.ToLower() == ttext.ToLower() && ttext != "")
                    {
                        textmatch = core.GetVar(Lin, "string");
                        if (textmatch != "")
                        {
                            sr.Close();
                            return brfix(textmatch,allowbr);
                        }
                        
                    }
                    if (name.ToLower() == tname.ToLower() && tname != "")
                    {
                        namematch = core.GetVar(Lin, "string");
                        if (namematch != "")
                        {
                            sr.Close();
                            return brfix(namematch,allowbr);
                        }
                    }
                }
                else core.ReadWordLine(Lin, -1, true,ref sr);
       
            }
            sr.Close();
           
            if (namematch != "") return brfix(namematch,allowbr);
            else if (textmatch != "") return brfix(textmatch,allowbr);

            // if we are here we have no match
            if (name.Length > 0 && defaulttext.Length > 0 && VbX.CInt(core.GetIniVal("DeveloperAddMluiUnk", "0")) > 0)
            {
                System.IO.StreamWriter sw = new System.IO.StreamWriter("res\\mlui\\" + UiLangPack, true, System.Text.Encoding.GetEncoding("utf-16"));
                string lin = "\\MLI-V1" + "\\" + FileTemp + "\\";
                lin = core.SetVar(lin, "text", defaulttext);
                lin = core.SetVar(lin, "name", name);
                lin = core.SetVar(lin, "string", defaulttext);

                sw.WriteLine(lin);
                sw.Close();
            }
            //if (defaulttext=="") return name;
            return brfix(defaulttext,allowbr);
        }
    }
}
