﻿
namespace BenkyouStudio
{

    public static class clsTextCommand
    {
        public static bool DoTextCommand(InstantForm sender,string lin)
        {
            switch (lin.ToLower().Replace(" ", ""))
            {
           
                case "fileconverter":
                    {
                        FrmFileConverter ffc = new FrmFileConverter();
                        ffc.Show();
                        break;
                    }
                case "texttricks":
                    {
                        FrmTextTricks ffc = new FrmTextTricks();
                        ffc.Show();
                        break;
                    }
                case "fileeditor": {
                    System.Windows.Forms.OpenFileDialog fd = new System.Windows.Forms.OpenFileDialog();
                    fd.Filter = "All files (*.*)|*.*";
                    System.Windows.Forms.DialogResult dr = fd.ShowDialog();
                    if (dr == System.Windows.Forms.DialogResult.OK) { FrmListEditor ffc = new FrmListEditor("file", fd.FileName); ffc.Show();  }
                    break;
                }
                case "listeditor": { FrmListEditor ffc = new FrmListEditor("",""); ffc.Show(); break; }
                case "resourcebuilder": { FrmResourceBuilder ffc = new FrmResourceBuilder(); ffc.Show(); break; }
                case "charactermap": { FrmCharacterMap cm = new FrmCharacterMap(); cm.Show(); break; }
                case "unicodeconverter": { FrmUnicodeConvert ffc = new FrmUnicodeConvert(); ffc.Show(); break; }
                case "speechnone": core.speech = 0; core.mute = 0; break;
                case "speechquiz": core.speech = 2; core.mute = 0; break;
                case "speechall": core.speech = 3; core.mute = 0; break;
                case "mouseflash":
                    if (core.MaxData < 0) { VbX.MsgBox("No Words in wordlist"); break; }
                    if (core.flashcardform != null)
                    {
                        core.flashcardform.Close();
                        core.flashcardform = null;
                    }
                    else
                    {
                        core.flashcardform = new MouseFlashClass();
                        core.flashcardform.Show();
                    }
                    break;

                case "texttospeech":
                    BenkyouStudio.FrmSayit frm = new BenkyouStudio.FrmSayit();
                    frm.Show();
                    break;
                case "randsort":
                    {
                        int i = 0;
                        int done = 0;
                        do
                        {
                            int r = VbX.CInt(VbX.Rnd() * core.MaxData + 1); ;
                            if (1 == 1)
                            {
                                string tl = core.WordArray[r];
                                core.WordArray[r] = core.WordArray[i];
                                core.WordArray[i] = tl;
                            }
                            i++;
                            if (i == core.MaxData) { done = 1; }

                        } while (done == 0);
                    }
                    break;
                
                case "makewaves":
                    if (VbX.InputBox("Benkyou Studio", "This will export all the flashcards as wav files", "yes/no").ToLower() == "*yes*")
                    {   int i = 0;
                        int filect = 1111;
                        int filenum = 0;
                        int searchscore = -21;
                        string Temp = "";
                        if (!System.IO.Directory.Exists("wav")) {
                            System.IO.Directory.CreateDirectory("wav");
                        }
                        do
                        {
                            int ts=core.GetScore(i);

                            if (searchscore == ts || (searchscore ==-21 && ts==999))
                            {

                                if (filect >= 1000)
                                {
                                    System.Windows.Forms.Application.DoEvents();

                                    if (Temp.Length > 0) sayitmod.sayit(Temp, "pause");
                                    System.Windows.Forms.Application.DoEvents();

                                    Temp = "w>wav\\BenkyouStudio_" + VbX.Right("000" + filenum.ToString(), 3) + "_" + core.GetScore(i).ToString() + ".wav`";


                                    System.Windows.Forms.Application.DoEvents();
                                    filect = 0; filenum++;

                                }

                                int tempnum = core.FindRandomQuizByWord(i,true);
                                //string flashcardtemplate = core.DoStringVars(core.GetVar(core.QuizLayout[tempnum], "Sequence"), "", "%");
                                string SpeechSequence = core.DoStringVars(core.GetVar(core.QuizLayout[tempnum], "SpeechSequence"), "", "%");
                                SpeechSequence = core.DoStringVars(SpeechSequence, core.WordArray[i], "%");
                                //VbX.MsgBox(SpeechSequence);
                                string splitter = core.GetSplitter(SpeechSequence);
                                string sline = "";
                                for (int sl = 1; sl <= ss.CountItems(SpeechSequence, splitter); sl++) {
                                    // limit to 100 to stop any silly long lines
                                    sline += ss.GetItem(SpeechSequence, splitter, sl).Left(100)+"`";
                                }
                                Temp += sayitmod.speedspeek(sline);
                                 //string VoiceJ = "l>jpn`l>haruka`r>-2`";
                                //public static String VoiceJdict = "l>jpn`l>kyoko`r>-2`";
                                //string VoiceE = "l>us;gb`r>2`";
                                //Temp = Temp + VoiceJ + core.GetWordVar(i, "jpn-h") + "`" + VoiceE + sayitmod.speedspeek(core.GetWordVar(i, "eng").Left(100));
                                /*
                               // get the kanji meaning
                               String lblkanjinames = core.kengsearch2(core.KanjiOnly( core.DataK[i]));
                               if (lblkanjinames.Length > 0)
                               {
                                   String KanjiSpeech = lblkanjinames;
                                   KanjiSpeech = KanjiSpeech.Replace("]", " ");
                                   KanjiSpeech = KanjiSpeech.Replace("[", " ");
                                   KanjiSpeech = KanjiSpeech.Replace("   ", " ");
                                   KanjiSpeech = KanjiSpeech.Replace("  ", " ");
                                   Temp = Temp + " can g " + KanjiSpeech;
                               }
                                  */
                                Temp = Temp + "`";
                                filect++;
                            }
                            i++;
                            if (i > core.MaxData)
                            {
                                i = 0;
                                searchscore++;
                            }

                        }
                        while (i <= core.MaxData && searchscore <= 20);
                        //
                        //VbX.MsgBox(Temp);
                        sayitmod.sayit(Temp, "pause");
                        VbX.MsgBox(ui.GetTrans("MakewavesDone","Done Files Saved to 'Wav' folder", false));
                    }
                    break;
                case "mute":
                    {

                        core.mute = 1 - core.mute;
                        if (core.mute == 0)
                        {

                            VbX.PopFormTime("Benkyou Studio", ui.GetTrans("UnMuted", "Speech is Enabled", false), 1000);
                        }
                        else
                        {
                            VbX.PopFormTime("Benkyou Studio", ui.GetTrans("Muted", "Speech is Muted", false), 1000);
                        }
                    } break;
    

                case "dictionary":
                    
                    if (core.mysearch == null)
                    {
                        frmSearch f2 = new frmSearch();
                        core.mysearch = f2;
                    }
                    core.mysearch.Show();
                    core.mysearch.BringToFront();
                    core.mysearch.Focus();
                    break;
                case "frmbmpbuilder":
                    {
                        FrmBmpBuilder f = new FrmBmpBuilder();
                        f.Show();
                            break;
                    }
                case "reloadglobals": {
                    if (VbX.CInt(core.GetIniVal("MinZeroWords", "0")) < 0) core.ScoreBlankVal = "0";
                    core.DeveloperMode = VbX.CInt(core.GetIniVal("DeveloperMode", "0"));
                    core.UiTheme = core.GetIniVal("UiTheme", "");
                    core.speech = VbX.CInt(core.GetIniVal("speech", "0"));
                    core.SetIniVal("SoftwareVersion", core.version, true);
                    core.DefaultFont = core.GetIniVal("DefaultFont", "");
                     

              
                    break;
                }
                case "quiz":
                    {
                        if (core.MaxData < 0) { VbX.MsgBox("No Words in wordlist"); break; }
                        if ((core.flashcardform != null))  core.flashcardform.Visible = false;
                        FrmQuestion q = new FrmQuestion(core.rangelimitI(core.GetIniVal("quizlength", "2"),2,1000,2), -1);
                        q.ShowDialog();
                        if ((core.flashcardform != null))  core.flashcardform.Visible = true; 
                    }
                    break;
            
                case "savescores":
                    core.savescores(core.WordFile); break;
                case "applicationexit":
                    core.savescores(core.WordFile);
                    if (sender != null)
                    {
                        if (sender.RootForm != null) sender.RootForm.Close();
                    }
                    break;
                case "showscoresform":
                    core.SetIniVal("ScoresReport", core.showscores(),true);
                    if (System.IO.File.Exists("res/frm/scores.frm")) new frmInstantForm("res/frm/scores.frm").Show();
                    break;
               
                
            }
            return false;
        }
        
    }
}