﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace BenkyouStudio
{
    public delegate bool InstantFormEventOccured(InstantForm sender,string lin);
    public class InstantForm

    {
        public event InstantFormEventOccured EventOccured;
        public int OriginX = 0;
        public int PosX = 0;
        public int PosY = 0;
        
        public int MinXSize = 100;
        public int MinYSize = 10;
        public int ThisXSize = 0;
        public int ThisYSize = 0;
        public bool formthemed = false;
        public Control RootControl;
        
        public Control CurrentControl=null;
        public MenuStrip menuStrip = null;
        public Form RootForm;
        public InstantForm(Form sender,bool hasScrollBars) {
            RootForm = sender;
            if (RootControl == null) {
                Control mainpnl = new Panel();
                //ifrm.RootControl = mainpnl;
                //frm.RootForm = this;

                if (hasScrollBars == true)
                {
                    mainpnl.Width = RootForm.Width - 20;
                    mainpnl.Height = RootForm.Height - 20;
                }
                else {
                    mainpnl.Width = RootForm.Width - 4;
                    mainpnl.Height = RootForm.Height - 4;
                    ((Panel)mainpnl).AutoScroll = true;
                    
                
                }
                mainpnl.Anchor = AnchorStyles.Bottom | AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right;
                RootForm.Controls.Add(mainpnl);
                RootControl = mainpnl;
                BR();
            }
            CurrentControl = RootControl;
        }

        public void fromstring(string lin)
        {
            if (CurrentControl == null) CurrentControl = RootControl;
            
            switch (core.GetVar(lin, "type").ToLower())
            {
                case "setpos":
                    {
                        
                        if (core.GetVar(lin, "xpos") != "")
                        {
                            PosX = VbX.CInt(core.GetVar(lin, "xpos"));
                        
                        }
                        if (core.GetVar(lin, "ypos") != "")
                        {
                            PosY = VbX.CInt(core.GetVar(lin, "ypos"));
                        }
                        return;
                    }   
                case "setorigin": {
                    ThisXSize = MinXSize;
                    ThisYSize = MinYSize;
                    if (core.GetVar(lin, "x") != "")
                    {
                        OriginX = VbX.CInt(core.GetVar(lin, "x"));
                        PosX = OriginX;
                    }
                    if (core.GetVar(lin, "y") != "")
                    {
                        PosY = VbX.CInt(core.GetVar(lin, "y"));
                    }
                    return;
                }
                case "setspacing":
                    {
                        if (core.GetVar(lin, "x") != "") MinXSize = VbX.CInt(core.GetVar(lin, "x"));
                        if (core.GetVar(lin, "y") != "") MinYSize = VbX.CInt(core.GetVar(lin, "y"));

                        return;
                    }
                case "setfocus":
                    {
                        Control c = GetControl(RootControl, core.GetVar(lin, "name"));
                        if (c != null) c.TabIndex = 0 ;
                        return;
                    }
                case "themeform": {
                    ui.ThemeUi(RootForm);
                    formthemed = true; return; // need to theme before entering colored text on a richtextbox!
                }
                case "move":
                    {
                        Control c = GetControl(RootControl, core.GetVar(lin, "name"));
                        if (c != null)
                        {
                            int x = c.Location.X;
                            int y = c.Location.Y;
                            if (core.GetVar(lin, "settings") == "offset") {
                                if (core.GetVar(lin, "xpos") != "") x += str2int(core.GetVar(lin, "xpos"), c);
                                if (core.GetVar(lin, "ypos") != "") y += str2int(core.GetVar(lin, "ypos"), c);
                            } else {
                                if (core.GetVar(lin, "xpos") != "") x = str2int(core.GetVar(lin, "xpos"), c);
                                if (core.GetVar(lin, "ypos") != "") y = str2int(core.GetVar(lin, "ypos"), c);
                            }
                            
                            
                            
                            c.Location = new System.Drawing.Point(x, y);
                            
                        }
                    }
                    break;
                case "anchor":
                    {
                        string anchors = core.GetVar(lin, "settings").ToLower();
                        Control c = GetControl(RootControl, core.GetVar(lin, "name"));
                        if(c!=null){
                            c.Anchor=0;
                            if (anchors=="all") { c.Anchor = AnchorStyles.Bottom | AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right; return;}
                            if (anchors=="none" || anchors=="") return;
                            string anchorsplitter=core.GetSplitter(anchors);
                            for (int i=1;i<=ss.CountItems(anchors,anchorsplitter);i++){
                                string thisanchor=ss.GetItem(anchors,anchorsplitter,i);
                                    switch (thisanchor.ToLower()){
                                        case "left": c.Anchor|=AnchorStyles.Left;break;
                                        case "right": c.Anchor|=AnchorStyles.Right;break;
                                        case "top": c.Anchor|=AnchorStyles.Top;break;
                                        case "bottom": c.Anchor|=AnchorStyles.Bottom;break;
                                    
                                    }

                            }

                        }
                    }
                    break;
                case "image":
                    
                    AddImage(CurrentControl, core.GetVar(lin, "name"), core.GetVar(lin, "text"), VbX.CInt(core.GetVar(lin, "width")), VbX.CInt(core.GetVar(lin, "height"))); break;
                case "title":
                    AddTitle(CurrentControl, core.GetVar(lin, "name"), core.DoStringVars(core.GetVar(lin, "text"), "", "%"), VbX.CInt(core.GetVar(lin, "width"))); break;
                case "label":
                    {
                        string name = core.GetVar(lin, "name");
                        string text = core.DoStringVars(core.GetVar(lin, "text"), "", "%");

                        AddLabel(CurrentControl, name, text, VbX.CInt(core.GetVar(lin, "width"))); break;
                    }
                case "form":
                    {
                        RootForm.Text = core.GetVar(lin, "text");
                        int wid = VbX.CInt(core.DoStringVars(core.GetVar(lin, "width"), "", "%"));
                        int hei = VbX.CInt(core.DoStringVars(core.GetVar(lin, "height"), "", "%"));
                        if (hei > 0) RootForm.Height = hei;
                        if (wid > 0) RootForm.Width = wid;

                        if (System.IO.File.Exists(core.GetVar(lin, "imagefile"))) RootForm.Icon = new System.Drawing.Icon(core.GetVar(lin, "imagefile"));
                        if (core.GetVar(lin, "buttons") == "close")
                        {
                            RootForm.MaximizeBox = false;
                            RootForm.MinimizeBox = false;

                        }
                        if (core.GetVar(lin, "border") == "fixed") RootForm.FormBorderStyle = FormBorderStyle.FixedSingle;
                        /*
                        int BorderWidth = (RootForm.Width -) / 2;
                        int TitlebarHeight = RootForm.Height - RootForm.ClientSize.Height - 2 * BorderWidth;
                        int menuheight = 0;
                        if (menuStrip != null) { menuheight = menuStrip.Height; }

                        RootForm.Height = maxy + BorderWidth + TitlebarHeight + 4 + menuheight;
                        */
                        RootControl.Width =  RootForm.ClientSize.Width;
                        RootControl.Height =  RootForm.ClientSize.Height ;
                    
                    }
                    
                    break;
                case "setrichtext": {
                        string myDetailsLayout = core.GetVar(lin, "text");
                        Control c = GetControl(RootControl, core.GetVar(lin, "name"));
                        if (c == null) return;
                        string myDetailsLayoutSplitter = "/";
                        if (myDetailsLayout == "") {
                            string spl=core.GetVar(lin, "filesplitter");
                            myDetailsLayout = spl;
                            if (System.IO.File.Exists(core.GetVar(lin, "file"))) {
                                System.IO.StreamReader sr = new System.IO.StreamReader(core.GetVar(lin, "file"));
                                    while (sr.Peek()>=0){
                                        string sl=sr.ReadLine();
                                        myDetailsLayout += sl + spl + "BR"+spl;
                                    }
                                    sr.Close();
                            }
                            else myDetailsLayout = "`BR`File Missing:" + core.GetVar(lin, "file");
                        } 
                    
                        myDetailsLayoutSplitter = core.GetSplitter(myDetailsLayout);
                    
                        RichTextBox r = (RichTextBox)c;
                        r.DetectUrls = false;
                        r.ReadOnly = true;
                        r.SelectionStart = r.Text.Length;
                        for (int i = 1; i <= ss.CountItems(myDetailsLayout, myDetailsLayoutSplitter); i++)
                        {
                            string mypart = ss.GetItem(myDetailsLayout, myDetailsLayoutSplitter, i);
                            switch (mypart)
                            {
                                case "C1":
                                    r.SelectionColor = ui.ColorNum(1); break;
                                case "C2":
                                    r.SelectionColor = ui.ColorNum(2); break;
                                case "C3":
                                    r.SelectionColor = ui.ColorNum(3); break;
                                case "C4":
                                    r.SelectionColor = ui.ColorNum(4); break;
                                case "C5":
                                    r.SelectionColor = ui.ColorNum(5); break;
                                case "C6":
                                    r.SelectionColor = ui.ColorNum(6); break;
                                case "BR":
                                    r.SelectedText = VbX.Chr(13) + VbX.Chr(10); break;
                                default:
                                    //string wordval = core.GetVar(lin, mypart);
                                  
                                        r.SelectedText = mypart;
                                    break;
                            }
                        };
                        r.SelectionStart = 0; r.SelectionLength = 0;
                        
                    }   
                    break;
                case "richtext":
                case "richtextbox":
                    AddRichText(CurrentControl, core.GetVar(lin, "name"), core.GetVar(lin, "text"), VbX.CInt(core.GetVar(lin, "width")), VbX.CInt(core.GetVar(lin, "height"))); return;
                    
                case "text":
                case "textbox":
                    if (VbX.CInt(core.GetVar(lin, "height")) > 0) {
                        AddText(CurrentControl, core.GetVar(lin, "name"), gettext(lin), VbX.CInt(core.GetVar(lin, "width")), VbX.CInt(core.GetVar(lin, "height"))); 
                    }   else   {
                        AddText(CurrentControl, core.GetVar(lin, "name"), gettext(lin), VbX.CInt(core.GetVar(lin, "width"))); 
                    }; break;
                case "check":
                case "checkbox":
                    AddCheck(CurrentControl, core.GetVar(lin, "name"), gettext(lin), VbX.CInt(core.GetVar(lin, "width")),0,""); break;
                case "checklist":
                case "checkedlist":
                    {
                        string text = gettext(lin);
                        AddCheckList(CurrentControl, core.GetVar(lin, "name"), text, core.GetVar(lin, "items"), core.GetVar(lin, "values"), VbX.CInt(core.GetVar(lin, "width")), VbX.CInt(core.GetVar(lin, "height")), VbX.CInt(core.GetVar(lin, "colwidth")));
                        break;
                    }
                case "combo":
                case "combobox":
                case "dropdown":
                    
                    {
                        string text = gettext(lin);
                        ComboBox ctrl = AddCombo(CurrentControl, core.GetVar(lin, "name"), text, VbX.CInt(core.GetVar(lin, "width")));
                    if (core.GetVar(lin, "limit") != "") ctrl.DropDownStyle = ComboBoxStyle.DropDownList;
                        string myitems=core.DoStringVars(core.GetVar(lin, "items"), "", "%");
                        string myvalues = core.DoStringVars(core.GetVar(lin, "values"), "", "%");
                        
                        if (myitems.Length > 0) {
                            ctrl.DisplayMember = "Name";
                            ctrl.ValueMember = "Value";
                            string splitter = core.GetSplitter(myitems);
                            string splitter2 = core.GetSplitter(myvalues);
                            for (int i = 1; i <= ss.CountItems(myitems, splitter); i++)
                            {
                                string thisitem = ss.GetItem(myitems, splitter, i);
                                string thisvalue = ss.GetItem(myvalues, splitter2, i);
                                if (thisvalue == "") thisvalue = thisitem;
                                ComboItem a = new ComboItem();
                                a.Name = thisitem;
                                a.Value = thisvalue;
                                ctrl.Items.Add(a);

                                if (text == thisvalue) ctrl.SelectedIndex = ctrl.Items.Count - 1;
                            }
                        }
                        

                        break;
                    }
                case "comboadd":
                case "comboboxadd":
                case "dropdownadd":
                    {
                        string text = gettext(lin);
                        ComboBox ctrl = (ComboBox)GetControl(CurrentControl, core.GetVar(lin, "name"));
                        string myitems = core.DoStringVars(core.GetVar(lin, "items"), "", "%");
                        string myvalues = core.DoStringVars(core.GetVar(lin, "values"), "", "%");
                        if (myitems.Length > 0)
                        {
                            ctrl.DisplayMember = "Name";
                            ctrl.ValueMember = "Value";
                            string splitter = core.GetSplitter(myitems);
                            string splitter2 = core.GetSplitter(myvalues);
                            for (int i = 1; i <= ss.CountItems(myitems, splitter); i++)
                            {
                                string thisitem = ss.GetItem(myitems, splitter, i);
                                string thisvalue = ss.GetItem(myvalues, splitter2, i);
                                if (thisvalue == "") thisvalue = thisitem;
                                ComboItem a = new ComboItem();
                                a.Name = thisitem;
                                a.Value = thisvalue;
                                ctrl.Items.Add(a);

                                if (text == thisvalue) ctrl.SelectedIndex = ctrl.Items.Count - 1;
                            }
                        }


                        break;
                    }
                case "nbsp":{
                    int ct = core.GetVar(lin, "text").Length;
                    if (ct == 0) ct = 1;
                    NBSP(ct);
                }; break;

                case "br": BR(); break;
                case "hr": HR(CurrentControl,VbX.CInt(core.GetVar(lin, "width"))); break;
                case "group": {
                    string name=core.GetVar(lin, "name");
                    string text=core.GetVar(lin, "text");
                    int wid = VbX.CInt(core.DoStringVars(core.GetVar(lin, "width"), "", "%"));
                    int hei = VbX.CInt(core.DoStringVars(core.GetVar(lin, "height"), "", "%"));
                    
                    GroupBox mp = AddGroup(CurrentControl, name, ui.GetTrans(name, text, false), wid, hei);

                    EnterPanel();
                    CurrentControl = mp;
                    MinXSize = 32;
                    ThisXSize = 32;
                    break;
                }
                case "groupend": {
                    CurrentControl = LeavePanel(CurrentControl, CurrentControl, true);

                }; break;
                case "groupsizer": AddGroupSizer(CurrentControl, core.GetVar(lin, "name"), 1); break;
                case "menu":
                    {

                        

                        if (menuStrip == null) {
                            menuStrip = new MenuStrip();
                            menuStrip.Dock = DockStyle.Top;
                            RootForm.Controls.Add(menuStrip);
                            menuStrip.BringToFront();
                            RootControl.Top += menuStrip.Height;
                        }

                        AddMenu(menuStrip, core.GetVar(lin, "name"), core.GetVar(lin, "text"));
                      
                    }; break;
                case "submenu": {
                    
                    ToolStripMenuItem c = GetMenu(menuStrip,core.GetVar(lin, "parent"));
                        if  (c!=null){
                         
                            AddSubMenu((c), core.GetVar(lin, "name"), core.GetVar(lin, "text"));
                        }

                }; break;
                case "submenumulti":
                    {

                        ToolStripMenuItem c = GetMenu(menuStrip, core.GetVar(lin, "parent"));
                        if (c != null)
                        {
                            string names= core.GetVar(lin, "name");
                            string texts=core.GetVar(lin, "text");
                            string nsplit=core.GetSplitter(names);
                            string tsplit=core.GetSplitter(texts);
                            for (int i=1;i<=ss.CountItems(names,nsplit);i++){
                                string thisname=ss.GetItem(names,nsplit,i);
                                string thistext=ss.GetItem(texts,nsplit,i);
                                AddSubMenu((c),thisname,thistext );    
                            }
                            
                        }

                    }; break;
                case "button":
                    {
                        
                        int wid=VbX.CInt(core.DoStringVars(core.GetVar(lin, "width"),"","%"));
                        int hei = VbX.CInt(core.DoStringVars(core.GetVar(lin, "height"), "", "%"));

                        if (hei == 0)
                        {
                         AddButton(CurrentControl, core.GetVar(lin, "name"), core.GetVar(lin, "text"), wid);
                        }
                        else
                        {
                            AddButton(CurrentControl, core.GetVar(lin, "name"), core.GetVar(lin, "text"),wid,hei, core.GetVar(lin, "imagefile")); 
                        }
                        break;
                    }
                default:
                    VbX.MsgBox("Unknown form command:"+lin);
                    break;
            }
        }
        public string gettext(string lin) { 
        string text=core.GetVar(lin, "text");
        string name = core.GetVar(lin, "name");
        if (VbX.Left(name.ToLower(), 4) == "ini_") { 
            string deflt=core.GetVar(lin, "default");
            text=core.GetIniVal(VbX.Right(name,name.Length-4),deflt);
        }
        return text;
        }
        public int str2int(string lin,Control c){
            int result=VbX.CInt(lin);
            switch (lin) { 
                case "midformx":
                    result=RootForm.Width / 2;
                    if (c != null) result -= c.Width / 2;
                    break;
                case "midformy":
                    result = RootForm.Height / 2;
                    if (c != null) result -= c.Height / 2;
                    break;
            }
        return result;
        }
        public ToolStripMenuItem AddMenu(MenuStrip menuStrip, string name, string text)
        {
            text = ui.GetTrans(name, text, false);
       //     VbX.MsgBox(text);
            ToolStripMenuItem one = new ToolStripMenuItem(text);
            one.Name = name;
            menuStrip.Items.Add(one);
            return one;
        }
        public void AddSubMenu(ToolStripMenuItem menuStrip, string name, string text)
        {
             text = ui.GetTrans(name, text, false);
            
            ToolStripMenuItem one = new ToolStripMenuItem(text);
            one.Name = name;
            menuStrip.DropDownItems.Add(one);
            one.Click += new System.EventHandler(this.genericEventHandler);
        }


        public Control LeavePanel(Control mainpnl, Control ctrl,bool autosize)
        {
            
            if (autosize == true)
            {
                mainpnl.Height = PosY;
                if (PosX>0) mainpnl.Height += ThisYSize;
            }
            //VbX.MsgBox("GroupMin_" + ctrl.Text);
            if (core.GetIniVal("GroupMin_" + ctrl.Text, "0") == "1")
            {
                Control gr = GetControl(RootControl, ctrl.Name+"_GroupSizer");
                gr.Text = "[+]";
                ctrl.Height = 16;
            }

            PosX = OriginX;
            PosY = ctrl.Location.Y + ctrl.Height;

            ThisXSize = MinXSize;
            ThisYSize = MinYSize;

            return ctrl.Parent;


        }
        public void EnterPanel()
        {
            PosX = 0;
            PosY =16; ;
            ThisXSize = MinXSize;
            ThisYSize = MinYSize;
        }
        public void NBSP(int count) {
            PosX += ThisYSize * count;
        }
        public void BR()
        {
            PosX = OriginX;
            PosY += ThisYSize;
            ThisXSize = MinXSize;
            ThisYSize = MinYSize;
        }
        public void HR(Control pnl, int width)
        {
            if (width == 0) width = PosX;
            BR();
            Panel ctrl = new Panel();
            ctrl.Name = "HR";
            ctrl.Height = 2;
            ctrl.BackColor = ui.ColorNum(-1);
            ctrl.ForeColor = ui.ColorNum(-1);
            PosY += ThisYSize / 2;
            dogenerics(pnl, ctrl, width,"HR", "");
            PosY -= ThisYSize / 2;
            BR();
            
        }
        public Control AddButton(Control pnl, string name, string text, int width,int height,string image)
        {

            image = core.DoStringVars(image, "", "%");
            //VbX.MsgBox(core.GetIniVal("INI_IconTheme",""));
            Button ctrl = new Button();
            if (image.Length > 0) { 
                if (System.IO.File.Exists(image)){
                    ctrl.Image = System.Drawing.Image.FromFile(image);
            
                    if (text.Length > 0 && width == height )
                    {
                        ctrl.ImageAlign = System.Drawing.ContentAlignment.MiddleCenter;
                        ctrl.TextAlign = System.Drawing.ContentAlignment.BottomCenter;
                    }
                    if (text.Length > 0 && width <80 && height<80 ) {
                        ctrl.ImageAlign = System.Drawing.ContentAlignment.TopCenter;
                        ctrl.TextAlign = System.Drawing.ContentAlignment.BottomCenter;
                     }
                    if (text.Length > 0 && width >=height*2)
                    {
                        ctrl.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
                        ctrl.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
                    }
                }
            }
            ctrl.Margin = new Padding(0, 0, 0, 0);
            ctrl.Height = height;
            ctrl.Click += new System.EventHandler(this.genericEventHandler);
            dogenerics(pnl, ctrl, width, name, text);
            return ctrl;
        }
        public void AddImage(Control pnl, string name, string file, int width,int height)
        {
            PictureBox ctrl = new PictureBox();
            if (System.IO.File.Exists(file))
            {
                
                ctrl.Image = System.Drawing.Image.FromFile(file);
                if (width <=0) ctrl.Width = ctrl.Image.Width;
                if (height <= 0) ctrl.Height = ctrl.Image.Height;
                if (width > 0) { ctrl.Width = width; ctrl.SizeMode = PictureBoxSizeMode.StretchImage; };
                if (height > 0) { ctrl.Height = height; ctrl.SizeMode = PictureBoxSizeMode.StretchImage; };
                    
                dogenerics(pnl, ctrl, -1, name, "");
            }
            else
            {
                VbX.MsgBox(ui.GetTrans("FileMissing","File Missing",false)+":" + file);
            }
        }
        public void AddGroupSizer(Control pnl, string name,int Defaultstate) {
            
            string lin = "[-]";
            Label ctrl=new Label();
            ctrl.Text=lin;
            ctrl.Name = name;
            
            ctrl.Font = new System.Drawing.Font("Courier New", 8.25f);
            ctrl.Height = 14;
            ctrl.Width = 28;
            ctrl.Location = new System.Drawing.Point((int)((pnl.Width) * .7), 0);
            pnl.Controls.Add(ctrl);
            ctrl.Click += new System.EventHandler(this.genericEventHandler);
            

        }
        public GroupBox AddGroup(Control pnl, string name, string text, int width, int height)
        {
            GroupBox ctrl = new GroupBox();
            ctrl.Height = height;
            //if (width == -1) ctrl.Width = ctrl.Image.Width;
            dogenerics(pnl, ctrl, width, name, text);
            
            return ctrl;
        }
        public void AddTitle(Control pnl, string name, string text, int width)
        {
            
            Label lbl = new Label();
            if (width == 0)
            {
                width = -1;
                lbl.AutoSize = true;
            }
            lbl.Font = new System.Drawing.Font(lbl.Font.Name, 13);
            dogenerics(pnl, lbl, width, name, text);
            
        }
        public void AddLabel(Control pnl, string name, string text, int width)

        {
            if (name == "") name="Lbl"+text.Replace(" ","");
            
            Label lbl = new Label(); lbl.AutoSize = true; dogenerics(pnl, lbl, width, name, text); }

        public void AddText(Control pnl, string name, string text, int width)
        { TextBox txt = new TextBox(); dogenerics(pnl, txt, width, name, text); 
        
        
        }
        public void AddText(Control pnl, string name, string text, int width, int height)
        {
            TextBox txt = new TextBox(); 
            txt.Height = height;
            txt.Multiline = true;
            txt.ScrollBars = ScrollBars.Both;
            dogenerics(pnl, txt, width, name, text);

        }
        public void AddCheck(Control pnl, string name, string text, int width, int height,string caption)
        {
            CheckBox chk = new CheckBox();
         //   chk.Height = height;
            if (text == "" || text.Trim() == "0") {
                chk.Checked = false;
            }
            else chk.Checked = true;
            chk.Text = caption;
            //VbX.MsgBox(caption);
            //chk.Multiline = true;
            //chk.ScrollBars = ScrollBars.Both;
            dogenerics(pnl, chk, width, name, "");

        }
        
        public void AddRichText(Control pnl, string name, string text, int width, int height)
        {

            RichTextBox txt = new RichTextBox();
            txt.Height = height;
            txt.Multiline = true;
            txt.ScrollBars = RichTextBoxScrollBars.Both;
            dogenerics(pnl, txt, width, name, text);

        }
        
        public ComboBox AddCombo(Control pnl, string name, string text, int width)
        {
            ComboBox ctrl = new ComboBox();


            dogenerics(pnl, ctrl, width, name, text);
            return ctrl;
        }
        public CheckedListBox AddCheckList(Control pnl, string name, string text, string myitems,string myvalues, int width, int height, int colwidth)
        {
            myitems = core.DoStringVars(myitems, "", "%");
            myvalues = core.DoStringVars(myvalues, "", "%");
            
            CheckedListBox ctrl = new CheckedListBox();
            if (colwidth > 0){
                ctrl.MultiColumn = true;
                ctrl.ColumnWidth = colwidth;
                
            }
            
                        if (myitems.Length > 0) {
                            ctrl.DisplayMember = "Name";
                            ctrl.ValueMember = "Value";
                            string splitter = core.GetSplitter(myitems);
                            string splitter2 = core.GetSplitter(myvalues);
                            for (int i = 1; i <= ss.CountItems(myitems, splitter); i++)
                            {
                                string thisitem = ss.GetItem(myitems, splitter, i);
                                string thisvalue = ss.GetItem(myvalues, splitter2, i);
                                if (thisvalue == "") thisvalue = thisitem;
                                ComboItem a = new ComboItem();
                                a.Name = thisitem;
                                a.Value = thisvalue;
                                ctrl.Items.Add(a);
                                //MessageBox.Show(thisvalue, text);
                                if (text.Contains(";"+thisvalue+";")) ctrl.SetItemChecked(ctrl.Items.Count - 1,true);
                            }
                        }


            ctrl.Height = height;
            dogenerics(pnl, ctrl, width, name, text);
            return ctrl;
        }
        public void AddButton(Control pnl, string name, string text, int width)
        {
            Button ctrl = new Button();
            ctrl.Click += new System.EventHandler(this.genericEventHandler);
            dogenerics(pnl, ctrl, width, name, text);
        }

        public void dogenerics(Control pnl, Control ctrl, int width, string name, string text)
        {
            ctrl.Location = new System.Drawing.Point(PosX, PosY);
            if (name != "") ctrl.Name = name;
            if (text != "") ctrl.Text = text;
            if (width >= 0)
            {
                if (width == 0) width = ThisXSize - 10;
                ctrl.Width = width;
            }
            pnl.Controls.Add(ctrl);
            if (ctrl.Width > ThisXSize) ThisXSize = ctrl.Width;
            if (ctrl.Height > ThisYSize) ThisYSize = ctrl.Height;
            PosX += ThisXSize;
            ThisXSize = MinXSize;
        }

        public void GroupSizerRefresh() {
            int i = 1;
            int maxy=0;
            Control obj=GetControl(RootControl,"Group_"+i.ToString());
            Control obj2 = null;
            while (obj != null){
                i++;
                if (obj2 != null) { obj.Top = obj2.Bottom+1;  }
                if (obj.Bottom > maxy) maxy = obj.Bottom;
                obj2 = obj;
                obj = GetControl(RootControl, "Group_" + i.ToString());
            }
          
            if (RootForm != null && maxy>0)
            {
                
                int BorderWidth = (RootForm.Width - RootForm.ClientSize.Width) /2;
                int TitlebarHeight = RootForm.Height - RootForm.ClientSize.Height - 2 * BorderWidth;
                int menuheight = 0;
                if (menuStrip != null) { menuheight = menuStrip.Height; }

                RootForm.Height = maxy + BorderWidth + TitlebarHeight + 4 + menuheight;
                
            }
        }

        // our events all go here
        public void genericEventHandler(object sender, EventArgs e)
        {
            string senderName = "";
            if (sender.GetType().Equals(typeof(ToolStripMenuItem)))
            {
                ToolStripMenuItem ctrl = (ToolStripMenuItem)sender;
                senderName = ctrl.Name;
            }
            else
            {
                Control ctrl = (Control)sender;
                senderName = ctrl.Name;
            }

            if (senderName.Contains("_GroupSizer")){
                Control gr = GetControl(RootControl, senderName.Replace("_GroupSizer",""));
                    if (gr!=null){
                        int NewH = 16;
                        if (gr.Height == 16)
                        {
                            NewH = GetTotalHeight(gr);
                            ((Control)sender).Text = "[-]";
                            for (int i = gr.Height; i < NewH; i += 3)
                            { gr.Height = i; GroupSizerRefresh(); RootForm.Refresh(); }
                            gr.Height = NewH;
                        }
                        else {
                            ((Control)sender).Text = "[+]";
                            for (int i = gr.Height; i > NewH; i -=3)
                            { gr.Height = i; GroupSizerRefresh(); RootForm.Refresh(); }
                            gr.Height = 16; 
                        }
                    }
            }


            if (EventOccured != null) { 
                EventOccured(this,senderName);
            }
            
            //MessageBox.Show(senderName);
        }

        // get the value of our controls
        public void SetVar(Control mainpnl, string name, string val)
        {
            foreach (Control c in mainpnl.Controls)
            {
                if (c.Name == name) c.Text = val;
            }
        }

        public string GetVar(Control mainpnl, string name, string def)
        {
            foreach (Control c in mainpnl.Controls)
            {
                if (c.Name == name)
                {

                    if (c.GetType().Equals(typeof(CheckedListBox)))
                    {
                        string response = ";";

                        foreach (ComboItem s in ((CheckedListBox)c).CheckedItems)
                        {
                            response += s.Value + ";";
                         //   MessageBox.Show(s.Name, s.Value);

                        }
                        return response;
                    }
                    if (c.GetType().Equals(typeof(CheckBox)))
                    {
                        if (((CheckBox)c).Checked) return "1"; else return "0";
                    }
                    if (c.GetType().Equals(typeof(ComboBox)))
                    {
                        if (((ComboBox)c).SelectedItem==null) return "";
                        return ((ComboItem)((ComboBox)c).SelectedItem).Value;
                    }
                    return c.Text;
                }
            }
            return def;
        }


        // reconfigure, or check the config of our controls
        public string GetAttrib(Control mainpnl, string name, string attrib, string def)
        {
            foreach (Control c in mainpnl.Controls)
            {
                switch (attrib)
                {
                    case "text":
                        if (c.Name == name) return c.Text;
                        break;
                }
            }
            return def;
        }

        public void SetAttrib(Control mainpnl, string name, string attrib, string val)
        {
            foreach (Control c in mainpnl.Controls)
            {
                switch (attrib)
                {
                    case "text":
                        if (c.Name == name) c.Text = val;
                        break;
                }
            }
            return;
        }
        public Control GetControl(Control mainpnl, string name)
        {
            foreach (Control c in mainpnl.Controls)
            {
                if (c.Name == name) return c;
                if (c.HasChildren) {
                    Control found = GetControl(c, name);
                    if (found != null) return found;
                }

            }
            return null;
        }
        public ToolStripMenuItem GetMenu(MenuStrip mainpnl, string name)
        {
            foreach (ToolStripMenuItem c in mainpnl.Items)
            {
                if (c.Name == name) return c;
                if (c.HasDropDownItems)
                {
                    ToolStripMenuItem found = GetMenu(c, name);
                    if (found != null) return found;
                }
            }
            return null;
        }
        public ToolStripMenuItem GetMenu(ToolStripMenuItem mainpnl, string name)
        {
            foreach (ToolStripMenuItem c in mainpnl.DropDownItems)
            {
                if (c.Name == name) return c;
                if (c.HasDropDownItems)
                {
                    ToolStripMenuItem found = GetMenu(c, name);
                    if (found != null) return found;
                }
            }
            return null;
        }
        public int GetTotalHeight(Control mainpnl)
        {
            int h = 0;
            foreach (Control c in mainpnl.Controls)
            {   if (c.Location.Y+c.Height>h) h=c.Location.Y+c.Height;}
            return h;
        }
        class ComboItem
        {
            public string Name { get; set; }
            public string Value { get; set; }
        }
    }
}
