﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;

namespace BenkyouStudio
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            VbX.Randomize();

            if (!System.IO.File.Exists("BenkyouStudio.exe") || !System.IO.File.Exists("res\\frm\\mainmenu.frm") || !System.IO.File.Exists("res\\frm\\about.txt"))
            { VbX.MsgBox(ui.GetTrans("SystemFilesMissing","System Files Not Found! Please read instructions and reinstall",false)); return; }
            
             core.WordFile="";
             string[] args = Environment.GetCommandLineArgs();
             if ((args != null))
             {
                 for (int i=1;i<=args.GetUpperBound(0);i++)
                     {
                         if (args[i].ToLower().Contains("safe"))
                         {
                             core.safety = 1;

                         } else {
                          core.WordFile = args[i];
                         }
                }
             }
           if (core.WordFile=="")
             {
                if (System.IO.File.Exists("StudyUsr.dat")) core.WordFile="StudyUsr.dat";
             }
           if (core.WordFile=="")
             {
                 if (System.IO.File.Exists(Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) + "\\BenkyouStudio\\StudyUsr.dat")) core.WordFile = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) + "\\BenkyouStudio\\StudyUsr.dat";
             }
            
              
                if (core.WordFile == "") {
                    new frmInstantForm("res\\frm\\BootStrap.frm").ShowDialog();
                    string mylng=core.GetIniVal("BootStrapLanguage", "");
                    if (mylng == "") return;
                    new frmInstantForm("res\\frm\\BootStrap_" + mylng + ".frm").ShowDialog();
                    string savepath = core.GetIniVal("BootStrapSavePath", "");
                    string defwords = core.GetIniVal("BootStrapDefaultWords", "");
                    string stdlng = core.GetIniVal("BootStrapStudyLanguage", "");
           
                    if (savepath == "program")
                    {
                        savepath="StudyUsr.dat";
                    }
                    else {
                      
                        savepath = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) + "\\BenkyouStudio";

                        System.IO.Directory.CreateDirectory(savepath);
                        System.IO.Directory.CreateDirectory(savepath + "\\Bak");
                        savepath += "\\StudyUsr.dat";
                    }
                    core.AppendFile("res\\cfg\\BootstrapLearn" + stdlng + ".cfg", savepath,false);
                    core.AppendFile("res\\cfg\\BootstrapNative" + mylng + ".cfg", savepath, true);
                    if (defwords=="yes"){
                        core.AppendFile("res\\cfg\\BootstrapWordlist.csv", savepath, true);
                    }
                    core.WordFile = savepath;
                    
                    //"BootStrapSavePath"
                    //"BootStrapDefaultWords"
                    //"BootStrapStudyLanguage"



                }

             System.IO.FileInfo fi = new System.IO.FileInfo(core.WordFile);
             if (!fi.Exists) {
                 VbX.MsgBox(core.WordFile + " "+ui.GetTrans("NotFound","Not found",false));
                 return;
             }

         

             if (fi.IsReadOnly) {
                 VbX.MsgBox(core.WordFile + ui.GetTrans("isreadonly"," is read only, Must be writable",false));
                 return;
             }
             System.IO.DirectoryInfo di = new System.IO.DirectoryInfo(new System.IO.FileInfo(core.WordFile).Directory.ToString());
             if (di.Attributes == System.IO.FileAttributes.ReadOnly)
             {
                 VbX.MsgBox(core.WordFile + ui.GetTrans("folderisreadonly", " is in a read only folder, Must be writable", false));
                 return;
             }
             core.loadFile(core.WordFile, false, false);
             if (core.MaxData == -1) {
                 // no words, so manually the save point
                 core.AddFilePoint("WRD");
             }

             string backpath = new System.IO.FileInfo(core.WordFile).Directory.ToString() + "\\bak";
             if (System.IO.Directory.Exists(backpath))
             {
                 DateTime dt = DateTime.Now;
                 string dts = "Day_" + dt.Day.ToString();
                 core.savescores(backpath+"\\" + dts + ".bak");
             }


            // modern vars
             clsTextCommand.DoTextCommand(null, "reloadglobals");
             
  /*           
            if (VbX.CInt(core.GetIniVal("MinZeroWords", "0"))<0) core.ScoreBlankVal = "0";
            core.DeveloperMode = VbX.CInt(core.GetIniVal("DeveloperMode", "0"));
            core.UiTheme = core.GetIniVal("UiTheme", "");
            core.speech = VbX.CInt(core.GetIniVal("speech", "0"));
            core.SetIniVal("SoftwareVersion", core.version,true);
*/
            Application.Run(new BenkyouStudio.frmInstantForm("res\\frm\\MainMenu.frm"));
            

            TextBox t = null;
            Form form = VbX.PopForm("Benkyou Studio", "Please Wait.. Saving", "nobuttons", ref t);
            double op = form.Opacity;
            form.Show();
            form.Refresh();

            clsTextCommand.DoTextCommand(null,"ApplicationExit");
            form.Close();
        }
    }
}
