﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace BenkyouStudio
{
    public partial class FrmUnicodeConvert : Form
    {
        public FrmUnicodeConvert()
        {
            InitializeComponent();
            textBox2.Font = new Font(FontFamily.GenericMonospace, 8);
            cboDataType.Text = "Text";
            ui.ThemeUi(this);
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            if (textBox1.Text.Length == 0) return;


            if (cboDataType.Text.ToLower() == "html unicode")
            {
                string myline = "";
                int pos = 0;
                string thisbit = "";
                bool ishex = false;
                while (pos < textBox1.Text.Length)
                {
                    string ch = textBox1.Text.Substring(pos, 1);
                    if (ch == "&" || ch == "#")
                    {
                        thisbit = "";
                        ishex = false;
                    }
                    else if (ch.ToLower() == "x")
                    {
                        ishex = true;
                    }
                    else if (ch.ToLower() == ";")
                    {
                        try
                        {
                            if (ishex == true)
                            {
                                myline += (char)Convert.ToInt32(thisbit, 16);
                            }
                            else
                            {
                                myline += (char)Convert.ToInt32(thisbit);
                            }

                        }
                        catch (Exception ex) {
                            System.Console.WriteLine("Error " + ex.ToString());        
                        }
                        thisbit = "";
                    }
                    else thisbit += ch;
                    pos++;
                };
                textBox2.Text ="Text:" + Environment.NewLine;
                textBox2.Text += myline + Environment.NewLine + Environment.NewLine;
                textBox2.Text +=doline(myline, false) + Environment.NewLine;
                    ;

                return;
            }
            else textBox2.Text = doline(textBox1.Text, true);
            
      
        }

        private string descr(string lin) { 
            switch ((int)lin.ToCharArray()[0]) {
                case 13:
                    return "NewLine";
                case 10:
                    return "CR";

            
            }
            return "";

        }
        private string doline(string inlin,bool htmlfooter) {

            string lin = "";
            lin += "Char" + " " + "Unicode".PadRight(7).Substring(0, 7);
            lin += "    " + "Hex".PadRight(7).Substring(0, 7) +"Notes"+ Environment.NewLine;
            string ulin1 = "";
            string ulin2 = "";
            for (int i = 0; i < inlin.Length; i++)
            {
                string mychar = inlin.Substring(i, 1);
                string bit1 = ((int)mychar.ToCharArray()[0]).ToString();
                string bit2 = ((int)mychar.ToCharArray()[0]).ToString("x");

                lin += mychar + "    " + bit1.PadRight(7).Substring(0, 7);
                lin += "    " + bit2.PadRight(7).Substring(0, 7) + descr(mychar);
                lin += Environment.NewLine;
                bit1 = "&#" + bit1 + ";";
                bit2 = "&#x" + bit2 + ";";
                ulin1 += bit1;
                ulin2 += bit2;


            }
            if (htmlfooter == true)
            {
                lin += Environment.NewLine + Environment.NewLine;
                lin += "html Unicode:" + Environment.NewLine;
                lin += ulin1 + Environment.NewLine + Environment.NewLine; ;
                lin += "html Hex Unicode:" + Environment.NewLine;
                lin += ulin2 + Environment.NewLine + Environment.NewLine; ;
                
            }
            return lin;
        }

        private void cboDataType_SelectedIndexChanged(object sender, EventArgs e)
        {
            textBox1_TextChanged(sender, e);
        }
    }
}
