﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace BenkyouStudio
{
    public partial class FrmTextTricks : Form
    {
        public FrmTextTricks()
        {
            InitializeComponent();
            cboTrick.Items.Add("KatakanaToHiragana");
            cboTrick.Items.Add("AddSplitter");
            cboTrick.Items.Add("KanaToRomanji");
            cboTrick.Items.Add("RomanjiToKana");
            cboTrick.Items.Add("ReverseLines");
            
            cboTrick.DropDownStyle = ComboBoxStyle.DropDownList;
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }

        private void btnGo_Click(object sender, EventArgs e)
        {
            switch (cboTrick.Text)
            {
                case "KatakanaToHiragana":
                    KanaToHira(); break;
                case "AddSplitter":
                    AddSplitter(); break;
                case "KanaToRomanji":
                    TxtText.Text = core.ConvertWithScript(TxtText.Text, "res\\cnv\\jpn-romanji.txt"); break;
                case "RomanjiToKana":
                    TxtText.Text = core.ConvertWithScript(TxtText.Text, "res\\cnv\\jpn-romanjirev.txt"); break;
                    
                case "ReverseLines":
                    ReverseLines(); break;
            }

        }
        private void ReverseLines() {
            string result = "";
            string lin = TxtText.Text.Replace(VbX.Chr(10), VbX.Chr(13));
            lin = lin.Replace(VbX.Chr(13) + VbX.Chr(13), VbX.Chr(13));
            for (int i = ss.CountItems(lin, VbX.Chr(13))-1; i >= 0; i--)
            {
                result += ss.GetItem(lin, VbX.Chr(13), i);
                
                result += VbX.Chr(13) + VbX.Chr(10);
            }
            TxtText.Text = result;
        }
        private void KanaToHira() {
            
            TxtText.Text = core.FormatConv(TxtText.Text, "jpn-k", "jpn-h");
        }
        private void AddSplitter() {
            string lin = TxtText.Text.Replace(VbX.Chr(10),VbX.Chr(13));
            string result="";
            lin=lin.Replace(VbX.Chr(13)+VbX.Chr(13),VbX.Chr(13));
            for (int i = 0; i <= ss.CountItems(lin, VbX.Chr(13)); i++)
            {
                result += "`TMP-V1`tmp`";
                string l2 = ss.GetItem(lin, VbX.Chr(13), i);
                for (int a = 0; a < l2.Length; a++) {
                    result+= "`"+l2.Substring(a, 1) ;
                }
               result += VbX.Chr(13) + VbX.Chr(10);
            }
            TxtText.Text = result;
            VbX.MsgBox("Done");
        }

        private void FrmTextTricks_Load(object sender, EventArgs e)
        {
            ui.ThemeUi(this);
        }
        
    }
}
