﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace BenkyouStudio
{
    public partial class FrmResourceBuilder : Form
    {
        public FrmResourceBuilder()
        {
            InitializeComponent();
            ui.ThemeUi(this);
            comboBox1.Items.Add("jpn: Build All Japanese");
            comboBox1.Items.Add("jpn: Build Edict");
            comboBox1.Items.Add("jpn: Build Edict Compact");
            comboBox1.Items.Add("jpn: Build KanjiDic");
            comboBox1.Items.Add("jpn: Build Edict Examples");
            comboBox1.Items.Add("jpn: Build Edict Names");
            comboBox1.Items.Add("jpn: Build jpn.Meanings.bad");
            comboBox1.Items.Add("jpn: Build jpn.Pronouncation.bad");
            comboBox1.Items.Add("zho: Build cedict");
            
            comboBox1.Items.Add("Build All FreeDict");
            
            
        }


        private void BtnGo_Click(object sender, EventArgs e)
        {
            switch (comboBox1.Text) {
                case "jpn: Build All Japanese":
                    DoEdict("ResSrc\\jpn\\edict", "jpn_eng","");
                    DoEdict("ResSrc\\jpn\\edict", "jpn_engC", "compact");
                    DoKanjiDict("ResSrc\\jpn\\kanjidic", "jpnkanji_eng.dic");
                    DoEdictExamples("ResSrc\\jpn\\examples", "jpn_eng.Examples.dic");
                    DoEdict("ResSrc\\jpn\\enamdict", "jpn-names_eng", "names"); 
                    break;
                case "jpn: Build jpn.Meanings.bad":
                    BadKanjiMeaning("res\\dict\\jpnkanji_eng.dic", "jpn.meanings.bad"); break;
                case "jpn: Build jpn.Pronouncation.bad":
                    BadKanjiPronounce("res\\dict\\jpn_eng.dic", "jpn.Pronouncation.bad"); break;

                case "jpn: Build Edict":
                    DoEdict("ResSrc\\jpn\\edict", "jpn_eng","");break;
                case "jpn: Build KanjiDic":
                    DoKanjiDict("ResSrc\\jpn\\kanjidic", "jpnkanji_eng.dic"); break;
                case "jpn: Build Edict Examples":
                    DoEdictExamples("ResSrc\\jpn\\examples", "jpn_eng.Examples.dic");break;
                case "jpn: Build Edict Names":
                    DoEdict("ResSrc\\jpn\\enamdict", "jpn-names_eng","names"); break;
                case "jpn: Build Edict Compact":
                    DoEdict("ResSrc\\jpn\\edict", "jpn_engC", "compact"); break;

                case "zho: Build cedict":
                    zho_Cedict("ResSrc\\zho\\cedict_ts.u8", "zho-eng.dic"); break;
                case "Build All FreeDict":
                    FreeDict("ResSrc\\freedict\\eng-deu.dict", "eng-deu.dic","eng","deu");
                    FreeDict("ResSrc\\freedict\\eng-fra.dict", "eng-fra.dic", "eng", "fra");
                    FreeDict("ResSrc\\freedict\\eng-gle.dict", "eng-gle.dic", "eng", "gle");
                    FreeDict("ResSrc\\freedict\\eng-ita.dict", "eng-ita.dic", "eng", "ita");
                    FreeDict("ResSrc\\freedict\\eng-lat.dict", "eng-lat.dic", "eng", "lat");
                    FreeDict("ResSrc\\freedict\\eng-nld.dict", "eng-nld.dic", "eng", "nld");
                    FreeDict("ResSrc\\freedict\\eng-rus.dict", "eng-rus.dic", "eng", "rus"); 
                    FreeDict("ResSrc\\freedict\\eng-spa.dict", "eng-spa.dic", "eng", "spa"); 
                    break;
            }
        }
        private void log(string lin) {
            
            textBox1.Text += lin + Environment.NewLine;
            this.Refresh();
        }
        private void BadKanjiMeaning(string source, string dest) {
            if (System.IO.File.Exists(source) == false) { log("File '" + source + "'Does not exist!"); return; };
            log("Creating from '" + source + "', writing to '" + dest + "'...");
            System.IO.StreamReader sr = new System.IO.StreamReader(source, System.Text.Encoding.GetEncoding("utf-16"));
            System.IO.StreamWriter sw = new System.IO.StreamWriter("res\\quiz\\" + dest, false, System.Text.Encoding.GetEncoding("utf-16"));
            sw.WriteLine("\\DEF-V1\\tmp\\Match\\BadSymbols");
             while (sr.Peek() >= 0)
             {
                 string Lin = sr.ReadLine();
                 string splitter = core.GetSplitter(Lin);
                 String FileVer = ss.GetItem(Lin, splitter, 1);
                 //if (FileVer.Equals("DEF-V1")) { core.settemplate(ss.GetItem(Lin, splitter, 2), Lin, true); };
                 if (FileVer.Equals("DCT-V1")) {
                     int rk = VbX.CInt(core.GetVar(Lin, "rk").ToLower().Replace("rk", ""));
                     if (rk > 0) { 
                         string jpnk=core.GetVar(Lin, "jpn");
                         string eng = core.GetVar(Lin, "eng").ToLower();
                         string jpnk_alt="";
                         //VbX.MsgBox(eng);
                         System.IO.StreamReader sr2 = new System.IO.StreamReader(source, System.Text.Encoding.GetEncoding("utf-16"));
                         while (sr2.Peek() >= 0)
                         {
                             
                             string Lin2 = sr2.ReadLine();
                             string splitter2 = core.GetSplitter(Lin2);
                             String FileVer2 = ss.GetItem(Lin2, splitter2, 1);
                             if (FileVer2.Equals("DCT-V1"))
                             {
                                   int rk2 = VbX.CInt(core.GetVar(Lin2, "rk").ToLower().Replace("rk", ""));
                                   if (rk2 > 0) {
                                       string eng2 = core.GetVar(Lin2, "eng");
                                       bool found=false;
                                       for (int i = 0; i <= ss.CountItems(eng2, "|"); i++)
                                       {
                                           string part = ss.GetItem(eng2, "|", i).Trim().ToLower() ;
                                           if (eng.Contains(part) && part.Length>3) found = true;
                                       }
                                       if (found) jpnk_alt += "|"+core.GetVar(Lin2, "jpn");
                                   }
                             }
                         }
                         sr2.Close();
                         sw.WriteLine("\\BAD-V1\\tmp\\|" + jpnk + "\\" + jpnk_alt);
                     }
                 } else core.ReadWordLine(Lin, -1, true, ref sr);
             }
            sr.Close(); sw.Close();
            log("Done");
        
        }
        private void BadKanjiPronounce(string source, string dest)
        {
            if (System.IO.File.Exists(source) == false) { log("File '" + source + "'Does not exist!"); return; };
            log("Creating from '" + source + "', writing to '" + dest + "'...");
            System.IO.StreamReader sr = new System.IO.StreamReader(source, System.Text.Encoding.GetEncoding("utf-16"));
            System.IO.StreamWriter sw = new System.IO.StreamWriter("res\\quiz\\" + dest, false, System.Text.Encoding.GetEncoding("utf-16"));
            sw.WriteLine("\\DEF-V1\\tmp\\Match\\BadSymbols");
            while (sr.Peek() >= 0)
            {
                string Lin = sr.ReadLine();
                string splitter = core.GetSplitter(Lin);
                String FileVer = ss.GetItem(Lin, splitter, 1);
                //if (FileVer.Equals("DEF-V1")) { core.settemplate(ss.GetItem(Lin, splitter, 2), Lin,true); };
                if (FileVer.Equals("DCT-V1"))
                {
                    
                        string jpnk = core.GetVar(Lin, "jpn");
                        string kata = core.GetVar(Lin, "jpn-k").ToLower();
                        kata=core.FormatConv(kata, "jpn-k", "jpn-h").Trim();
                        kata = kata.Replace(" ", "");
                        if (kata.Length > 0) {
                            sw.WriteLine("\\BAD-V1\\tmp\\|" + jpnk + "\\|" + kata);
                        }    
                    //sw.WriteLine("\\BAD-V2\\ini\\" + jpnk + "\\" + jpnk_alt);

                } else core.ReadWordLine(Lin, -1, true,ref sr);
            }
            sr.Close(); sw.Close();
            log("Done");

        }


        private void FreeDict(string source, string dest,string lang1,string lang2)
            // lang1 is native
        {
            if (System.IO.File.Exists(source) == false) { log("File '" + source + "'Does not exist!"); return; };
            log("Creating Build "+lang1+"-"+lang2+" from '" + source + "', writing to '" + dest + "'...");
            System.IO.StreamReader sr = new System.IO.StreamReader(source, System.Text.Encoding.GetEncoding("utf-8"));
            System.IO.StreamWriter sw = new System.IO.StreamWriter("res\\dict\\" + dest, false, System.Text.Encoding.GetEncoding("utf-16"));
            sw.WriteLine("\\DEF-V1\\ini\\IniVar\\IniVal\\RamVar");
            sw.WriteLine("\\INI-V1\\ini\\Dict_ResultsLayout\\;" + lang1 + ";30;" + lang2 + ";30\\1");
            sw.WriteLine("\\INI-V1\\ini\\Dict_DetailsLayout\\;C1;%"+lang1+"%;C2; - ;C3;%"+lang2+"%;BR\\1");
            sw.WriteLine("\\INI-V1\\ini\\Dict_Sayit\\l>"+lang2+"`%"+lang2+"%\\1");
            sw.WriteLine("\\INI-V1\\ini\\Dict_AddItems\\;" + lang1 + ";"+lang2);

            sw.WriteLine("\\DEF-V1\\dict_" + dest + "\\" + lang1 + "\\" + lang2);
            sw.WriteLine("\\DCT-V1\\dict_" + dest + "\\");
            string lin = "";
            // freedict has a gaky header, so lets try to skip it
            bool done = false;
            do {
                lin = sr.ReadLine();
                if (lin.Left(7)=="http://") done=true;
            } while (sr.Peek() >= 0 && !done);
            string lin1 = "";
            string lin2 ="";
            lin= sr.ReadLine();
            while (sr.Peek() >= 0)
            {
                if (VbX.Left(lin, 1) != " ")
                {
                    // found a new eng line


                    lin1 = lin1.Replace("\\", "-");
                    lin2 = lin2.Replace("\\", "-");

                    lin1 = lin1.Replace("/", " | ").Replace(";", " | ");
                    lin2 = lin2.Replace("/", " | ").Replace(";", " | ");


                    lin2 = lin2.Replace(" 1.", "").Replace(" 2.", "");
                    lin1 = lin1.Replace("   ", " ").Replace("  ", " ");
                    lin2 = lin2.Replace("   ", " ").Replace("  ", " ");
                    
                    // the first line of freedict have the format eng / phonetics - we only want the ENG!
                    lin1 = ss.GetItem(lin1, "|", 0);


                    lin1 = lin1.Trim();
                    lin2 = lin2.Trim();
                    if (lin1.Length>0) if (lin1.Substring(lin1.Length-1, 1) == "|") lin1 = lin1.Substring(0, lin1.Length - 1).Trim();
                    if (lin2.Length > 0) if (lin2.Substring(lin2.Length - 1 , 1) == "|") lin2 = lin2.Substring(0, lin2.Length - 1).Trim();


                    sw.WriteLine("^" + lin1 + "\\" + lin2);
                    lin2 = ""; lin1 = "";
                    lin1 = lin;
                }
                else {
                     // freedict has one english line followed by one or more non english lines - which are indented by a space
                    if (lin2.Length > 0) lin2 += " | ";
                    lin2 = lin2 + lin;
                }
                lin = sr.ReadLine();    
            }
            sr.Close(); sw.Close();
            log("Done");
        }
        private void zho_Cedict(string source, string dest)
        {
            if (System.IO.File.Exists(source) == false) { log("File '" + source + "'Does not exist!"); return; };
            log("Creating Build zho_Cedict from '" + source + "', writing to '" + dest + "'...");
            System.IO.StreamReader sr = new System.IO.StreamReader(source, System.Text.Encoding.GetEncoding("utf-8"));
            System.IO.StreamWriter sw = new System.IO.StreamWriter("res\\dict\\" + dest, false, System.Text.Encoding.GetEncoding("utf-16"));
            sw.WriteLine("\\DEF-V1\\ini\\IniVar\\IniVal\\RamVar");
            sw.WriteLine("\\INI-V1\\ini\\Dict_ResultsLayout\\;zho;10;zho-s;10;eng;30;zho-r;30\\1");
            sw.WriteLine("\\INI-V1\\ini\\Dict_DetailsLayout\\;C1;%zho%;C2; - ;C3;%zho-s%;C2; - ;C4;%zho-r%;C2; - ;C5;%eng%;BR\\1");
            sw.WriteLine("\\INI-V1\\ini\\Dict_Sayit\\l>zho`%zho-s%\\1");


            sw.WriteLine("\\DEF-V1\\dict_" + dest + "\\" + "zho\\zho-s\\zho-r\\eng");
            sw.WriteLine("\\DCT-V1\\dict_");
             while (sr.Peek() >= 0)
             {
                 string lin = sr.ReadLine() + "END/";
                 lin = lin.Replace("/END/", "").Replace("\\", " | ");
                 lin = lin.Replace("] /", "\\").Replace(" [", " \\").Replace("/", " | ").Replace("END/","");


                 lin = lin.Replace("   ", " ").Replace("  ", " ");
                 string zho = ss.GetItem(lin," ",0);
                 string zhos = ss.GetItem(lin, " ", 1);
                 string zhor = ss.GetItem(lin, "\\", 1).Trim();
                 string eng = ss.GetItem(lin, "\\", 2).Trim();
                 sw.WriteLine("^" + dest + "\\" + zho + "\\" + zhos + "\\" + zhor + "\\" + eng);
             }
            sr.Close(); sw.Close();
            log("Done");
        }
        private void DoEdictExamples(string source, string dest)
        {
            if (System.IO.File.Exists(source) == false) { log("File '" + source + "'Does not exist!"); return; };
            log("Creating Build Edict Examples from '" + source + "', writing to '" + dest + "'...");
            System.IO.StreamReader sr = new System.IO.StreamReader(source, System.Text.Encoding.GetEncoding("euc-jp"));
            System.IO.StreamWriter sw = new System.IO.StreamWriter("res\\dict\\"+dest, false, System.Text.Encoding.GetEncoding("utf-16"));
            sw.WriteLine("\\DEF-V1\\ini\\IniVar\\IniVal\\RamVar");
            sw.WriteLine("\\INI-V1\\ini\\Dict_ResultsLayout\\;jpn;30;eng;30\\1");
            sw.WriteLine("\\INI-V1\\ini\\Dict_DetailsLayout\\;C1;%jpn%;C4; - ;%eng%;C2; - ;%jpn-k2%;BR");
            sw.WriteLine("\\INI-V1\\ini\\Dict_Sayit\\l>jpn`l>kyoko`r>-2`%jpn%`l>jpn`l>haruka`r>-2`%jpn%\\1");


            sw.WriteLine("\\DEF-V1\\dict_"+dest+"\\" + "jpn\\eng\\jpn-k2");
            sw.WriteLine("\\DCT-V1\\dict_" + dest + "\\");
            while (sr.Peek() >= 0)
            {
                string lin = sr.ReadLine().Replace("\\", "-").Replace("A: ", "").Replace("#ID=", "\\");
                string lin2 = sr.ReadLine().Replace("\\", "-").Replace("B: ", "");
                string datak=ss.GetItem(lin,VbX.Chr(9),0);
                string datak2 =lin2;
                string datae =  ss.GetItem(lin, VbX.Chr(9), 1);
                datae = ss.GetItem(datae, "\\", 0); // get rid of the #id thing

                sw.WriteLine("^" + datak + "\\" + datae + "\\" + datak2);
            };
            sr.Close(); sw.Close();
            log("Done");

        }
        private void DoKanjiDict(string source, string dest)
        {
            if (System.IO.File.Exists(source) == false) {log("File '" + source + "'Does not exist!");return;};

        log("Creating Edict from '"+source+"', writing to '"+dest+"'...");
            System.IO.StreamReader sr = new System.IO.StreamReader(source, System.Text.Encoding.GetEncoding("euc-jp"));


            // build the kana header
            System.IO.StreamWriter sw = new System.IO.StreamWriter("res\\dict\\" + dest, false, System.Text.Encoding.GetEncoding("utf-16"));
            sw.WriteLine("\\DEF-V1\\ini\\IniVar\\IniVal\\RamVar");
            sw.WriteLine("\\INI-V1\\ini\\Dict_ResultsLayout\\;jpn;2;jpn-h;15;jpn-k;15;eng;15;rk;5;unicode;5\\1");
            sw.WriteLine("\\INI-V1\\ini\\Dict_DetailsLayout\\;C1;%jpn%;C2;   (;%unicode%;)  ;C3;(;%rk%;);C4;  -  ;%eng%;  -  ;C5;%jpn-h%;C6;%jpn-k%;BR");
            sw.WriteLine("\\INI-V1\\ini\\Dict_Sayit\\l>jpn`l>kyoko`r>-2`%jpn%`l>jpn`l>haruka`r>-2`%jpn%\\1");
            /*
            sw.WriteLine("\\INI-V1\\ini\\Dict_Details_Wait\\3000\\1"); // time until details are show
            sw.WriteLine("\\INI-V1\\ini\\Dict_Details_File\\res/dict/jpnkanji_eng.dic\\1");    // filename of details
            sw.WriteLine("\\INI-V1\\ini\\Dict_Details_Type\\word\\1"); // symb or word
            sw.WriteLine("\\INI-V1\\ini\\Dict_Details_LookFor\\jpn\\1"); // the column in the results to look for 
            sw.WriteLine("\\INI-V1\\ini\\Dict_Details_ResultsLimit\\10\\1"); // no of results to find
            */
            sw.WriteLine("\\INI-V1\\ini\\Dict_Details_Wait\\3000\\1"); // time until details are show
            sw.WriteLine("\\INI-V1\\ini\\Dict_Details_File\\res/dict/jpn_eng.Examples.dic\\1");    // filename of details
            sw.WriteLine("\\INI-V1\\ini\\Dict_Details_Type\\word\\1"); // symb or word
            sw.WriteLine("\\INI-V1\\ini\\Dict_Details_LookFor\\jpn\\1"); // the column in the results to look for 
            sw.WriteLine("\\INI-V1\\ini\\Dict_Details_ResultsLimit\\5\\1"); // no of results to find
            


            sw.WriteLine("\\DEF-V1\\dict_" + dest + "\\" + "jpn\\unicode\\rk\\eng\\jpn-h\\jpn-k");
            sw.WriteLine("\\DCT-V1\\dict_" + dest + "\\");
            while (sr.Peek() >= 0)
            {
                string datak = "";
                string datae = "";
                string datark = "";
                string datau = "";
                string datah = "";
                string datah2 = "";
                string lin = sr.ReadLine().Replace("\\","-");
                //lin = lin.Replace("} {", ";").Replace("}", "").Replace(" {", "\\");
                datak = ss.GetItem(lin, " ", 0);
                datau = ss.GetItem(lin, " ",2);
                

                
                for (int i=3;i<ss.CountItems(lin, " ");i++){
                   
                    string subitem =ss.GetItem(lin, " ",i);
                    if (subitem.Length > 0)
                    {
                        string startchar = subitem.Substring(0, 1);
                        if (startchar.ToLower() == "l" && datark == "")
                        {
                            datark = subitem.Replace("L", "RK");
                        }
                        if (startchar == "{")
                        {
                            if (datae.Length > 0) datae += " | ";
                            datae += subitem.Replace("{", "").Replace("}", "").Trim();
                        }
                        if (core.CharType(startchar) == "jpn-h")
                        {
                            if (datah.Length > 0) datah += " | ";
                            datah += subitem;
                        }
                        if (core.CharType(startchar) == "jpn-k")
                        {
                            if (datah2.Length > 0) datah2 += " | ";
                            datah2 += subitem;
                        }
                    }
                };


                sw.WriteLine("^" + datak + "\\" + datau + "\\" + datark + "\\" + datae + "\\" + datah + "\\" + datah2);
            };
            sr.Close(); sw.Close();
            log("Done");

        }
        private void DoEdict(string source, string dest, string mode)
        {
            if (System.IO.File.Exists(source) == false) { log("File '" + source + "'Does not exist!"); return; };
            System.IO.StreamReader sr = new System.IO.StreamReader(source, System.Text.Encoding.GetEncoding("euc-jp"));

            log("Creating Edict from '" + source + "', writing to '" + dest + "'...");
            string ext = "";
            do
            {

                System.IO.StreamWriter sw = new System.IO.StreamWriter("res\\dict\\" + dest + ext + ".dic", false, System.Text.Encoding.GetEncoding("utf-16"));

                sw.WriteLine("\\DEF-V1\\ini\\IniVar\\IniVal\\RamVar");

                if (ext == "_romanji")
                {
                    sw.WriteLine("\\INI-V1\\ini\\Dict_ResultsLayout\\;jpn;10;jpn-r;10;jpn-h;15;eng;30\\1");
                    sw.WriteLine("\\INI-V1\\ini\\Dict_DetailsLayout\\;C1;%jpn%;C2; - ;C3;%jpn-r%; - ;%jpn-h%; - ;C4;%eng%;C5;... %WordType%;BR\\1");
                    sw.WriteLine("\\INI-V1\\ini\\Dict_AddItems\\;jpn;jpn-r;jpn-h;eng");
                }
                else
                {
                    sw.WriteLine("\\INI-V1\\ini\\Dict_ResultsLayout\\;jpn;10;jpn-h;15;eng;30\\1");
                    sw.WriteLine("\\INI-V1\\ini\\Dict_DetailsLayout\\;C1;%jpn%;C2; - ;C3;%jpn-h%; - ;C4;%eng%;C5;... %WordType%;BR\\1");
                    sw.WriteLine("\\INI-V1\\ini\\Dict_AddItems\\;jpn;jpn-h;eng");
                }

                sw.WriteLine("\\INI-V1\\ini\\Dict_Sayit\\l>jpn`l>kyoko`r>-2`%jpn%`l>jpn`l>haruka`r>-2`%jpn%\\1");

                // we can define a chained details (examples or kanki breakdown)
                sw.WriteLine("\\INI-V1\\ini\\Dict_Details_Wait\\3000\\1"); // time until details are show
                sw.WriteLine("\\INI-V1\\ini\\Dict_Details_File\\res/dict/jpnkanji_eng.dic\\1");    // filename of details
                sw.WriteLine("\\INI-V1\\ini\\Dict_Details_Type\\symb\\1"); // symb or word
                sw.WriteLine("\\INI-V1\\ini\\Dict_Details_LookFor\\jpn\\1"); // the column in the results to look for 
                sw.WriteLine("\\INI-V1\\ini\\Dict_Details_ResultsLimit\\50\\1"); // no of results to find
                // we can chain to as many details as we want!

                //res/dict/jpn_eng.Examples.dic
                if (mode != "names")
                {
                    sw.WriteLine("\\INI-V1\\ini\\Dict_Details_Wait2\\3000\\1"); // time until details are show
                    sw.WriteLine("\\INI-V1\\ini\\Dict_Details_File2\\res/dict/jpn_eng.Examples.dic\\1");    // filename of details
                    sw.WriteLine("\\INI-V1\\ini\\Dict_Details_Type2\\word\\1"); // symb or word
                    sw.WriteLine("\\INI-V1\\ini\\Dict_Details_LookFor2\\jpn\\1"); // the column in the results to look for 
                    sw.WriteLine("\\INI-V1\\ini\\Dict_Details_ResultsLimit2\\5\\1"); // no of results to find
                }
                sw.WriteLine(",CHN-V1,>>>filename,res\\dict\\" + dest + ".chn");
                sw.Close();
                if (mode == "names") ext = "done";
                if (mode == "compact") ext = "done";
                if (ext == "_romanji") ext = "done";
                if (ext == "") ext = "_romanji";

            } while (ext != "done"); // mode != "names" - names doesnt need romanji

            

            {
                // build the core dictionary
                System.IO.StreamWriter sw = new System.IO.StreamWriter("res\\dict\\" + dest + ".chn", false, System.Text.Encoding.GetEncoding("utf-16"));

                sw.WriteLine("\\DEF-V1\\dict_" + dest + "\\" + "jpn\\jpn-h\\eng\\WordType\\jpn-r");

                // we use a file patch, swapping ^ for the last valid header.
                sw.WriteLine("\\DCT-V1\\dict_" + dest + "\\");
                while (sr.Peek() >= 0)
                {
                    string lin = sr.ReadLine();
                    string datatyp = " ";

                    // strip out markers we arent interested in
                    string replacers = ";(v1,vt);(ksb:);(exp,adv);(n-t);(pref);(n,adj-na);(conj);(exp,adj-pn);(exp,adj-f);(v2r-s,vi);(exp,n);(int,n,vs);(exp,adj-i);(exp,v5r);(adv-to,vs);(exp,v5u);(adj-na,n,adj-no);(int,n,vs);(adj-na,adv);(hon);(pn,adj-no);(conj,int);(suf,adj-no);(adv,adj-no);(rkb:);(exp,vs-i);";
                    replacers += "(chn);(v5u);(n,adj-no);(n-adv,n-t);(v1,vt);(adv-to,vs);(v5k);(v5r,vi);(v5m);(exp,v5s);(v5u,vt);(exp,v5k-s);(exp,v1);(adv,n,vs);(v5s,vi);(n,adj-no,vs);(exp,v5k);(int,n);(exp,adj-no);(adv,adv-to);(adv,adv-to,vs);(exp,n-adv);";
                    replacers += "(adv,vs);(adv-to);(adv,adv-to,vs);(v5r);(v5t,vi);(adv-to,adv,vs);(vi,v4r);(n-adv,n);(v5m,vt);(adj-na,adj-no,adv,vs);(exp,vk);(v5u,vi);(n,adj-na,adj-no);(v5k,vt);(vs-s);(v5t);(v2s-s,vi);(n,vs,adj-f);(v5m,vi);(n,adj-pn);(adj-na,n,vs);(conj,exp);(n,n-suf);(vk);(v2h-k);(v5b,vt);(v4r,vi);(n,n-adv);(v1,vi,vt);(v5g,vi);(exp,v5m);(v1,vt,exp);(v2m-s,vt);exp,v5g);(n,adj-na,n-pref);(adj-na,adj-no,adv,n)";

                    for (int r = 1; r < ss.CountItems(replacers, ";"); r++)
                    {
                        string bit = ss.GetItem(replacers, ";", r); lin = lin.Replace(bit, "");

                    }
                    datatyp = " ";
                    // move markers we are interested in
                    replacers = ";(food);(obs);(poet);(proverb);(conj);(yoji);(obsc);(anat);(pol);(comp);(abbr);(mil);(ateji);(sl);(med);(baseb);(math);(vulg);(sumo);(num);(chem);(sports);(mahj);(fam);(fem);(ik);(astron);(osb:);(derog);(joc);(kyb:);(ktb:);(hum);(prt);(kyu:);(ctr);(iK);(sens);(Buddh);(MA);(gikun);(physics);(law);(archit);(shogi);(pn);(oK);(pn)";
                    for (int r = 1; r < ss.CountItems(replacers, ";"); r++)
                    {
                        string bit = ss.GetItem(replacers, ";", r);
                        if (lin.Contains(bit))
                        {
                            lin = lin.Replace(bit, "");
                            datatyp += bit + " ";
                        }
                    }


                    // old code for stripping out
                    lin = lin.Replace("\\", "").Replace("/", " | ").Replace("[", "").Replace("]", "");
                    lin = lin.Replace("(adj-no,adj-na,n)", "");
                    lin = lin.Replace("(1)", "").Replace("(2)", "").Replace("(3)", "").Replace("(4)", "");
                    lin = lin.Replace("(P)/", "").Replace("(n,exp)", "").Replace("(adj-pn)", "").Replace("(adj-no,n)", "");
                    lin = lin.Replace("(v5k,vi)", "").Replace("(adj-t,adv-to)", "").Replace("(adj-na)", "");
                    lin = lin.Replace("(uk)", "").Replace("(exp,vi)", "").Replace("(v1)", "").Replace("(v5k,vi)", "").Replace("(v5s,vt)", "");
                    lin = lin.Replace("(n,adj-f)", "").Replace("(v5s)", "").Replace("(adj-f)", "").Replace("(v5r,vt)", "").Replace("(adv)", "").Replace("(io)", "");
                    lin = lin.Replace("(n,adv)", "").Replace("(ling)", "").Replace("(id)", "");
                    lin = lin.Replace("(on-mim)", "").Replace("(adj-i)", "").Replace("(int)", "").Replace("(adj-na,n)", "");
                    lin = lin.Replace("(biol)", "").Replace("(vs)", "").Replace("(adv,n)", "");
                    lin = lin.Replace("(arch)", "").Replace("(v1,vi)", "").Replace("(ok)", "").Replace("(n-adv)", "");
                    lin = lin.Replace("(col)", "").Replace("(adj-no)", "").Replace("(exp)", "").Replace("(n,ctr)", "");
                    lin = lin.Replace("(P)", "").Replace("(n,adj-no)", "");
                    lin = lin.Replace("(n)", "").Replace("(n,vs)", "").Replace("(n,vs,adj-no)", "").Replace("(adj-na,adj-no)", "");

                    lin = lin.Replace("||", "|").Replace("   ", " ").Replace("  ", " ");


                    string datak = "";
                    string datae = "";
                    string datah = "";
                    for (int i = 0; i <= ss.CountItems(lin, " "); i++)
                    {
                        string part = ss.GetItem(lin, " ", i);


                        if (part.Length > 0)
                        {
                            part = part.Trim();
                            string firstchar = part.Substring(0, 1);
                            // if (lin.Contains("keep alive message")) { VbX.MsgBox(part); VbX.MsgBox(core.CharType(firstchar)); }
                            if ((core.CharType(firstchar) == "jpn-h" || core.CharType(firstchar) == "jpn-k" || core.CharType(firstchar) == "jpn") && datak.Length == 0)
                            {
                                datak = part;

                            }
                            else if ((core.CharType(firstchar) == "jpn-h" || core.CharType(firstchar) == "jpn-k" || core.CharType(firstchar) == "jpn") && datah.Length == 0)
                            {
                                datah = part;

                            }
                            else
                            {
                                if (datae.Length > 0) datae += " ";
                                datae += part;
                            }
                        }

                    }

                    if (datah == "") datah = datak;
                    if (datae.Substring(0, 1) == "|")
                    {
                        datae = VbX.Right(datae, VbX.Len(datae) - 1);

                    }
                    if (VbX.Right(datae, 1) == "|")
                    {
                        datae = VbX.Left(datae, VbX.Len(datae) - 1);

                    }
                    
                    // tidy up datatype
                    datae = datae.Trim();
                    datatyp = datatyp.Replace(") (", "/");
                    datatyp = datatyp.Replace("(", "").Replace(")", "").Replace(" ", "");

                    string datar = "";

                    // reenable this

                    if (mode != "names" && mode != "compact") datar = core.ConvertWithScript(datah, "res\\cnv\\jpn-romanji.txt");
                    string newline = "^" + datak + "\\" + datah + "\\" + datae;

                    // name lines prob wont need these, so save a little space! (only 4 bytes but its something!)
                    if (datatyp!="" || datar!="") newline += "\\" + datatyp + "\\" + datar;
                    sw.WriteLine(newline);
                };
                sr.Close(); sw.Close();
                log("Done");
            }
        }
    }
}

