﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace BenkyouStudio
{
    public partial class FrmListEditor : Form
    {
        int liststart = 0;
        int skipcols = 3;
        string mymode = "";
        string mydata = "";
        System.IO.StreamReader sr = null;
        long srpos=9999999999;
        public FrmListEditor(string mode,string data)
        {
            InitializeComponent();
            lstItems.Font = new Font(FontFamily.GenericMonospace, 8);
            lstVars.Font = new Font(FontFamily.GenericMonospace, 8);
            mymode = mode;
            mydata = data;
            if (mymode=="file"){
                this.Text = "Editing..."+ mydata;
                sr = new System.IO.StreamReader(data);
                while (sr.Peek() >= 0 )               {
                    string Lin = sr.ReadLine();
                    string splitter = core.GetSplitter(Lin);
                    String FileVer = ss.GetItem(Lin, splitter, 1);
                    if (FileVer.Equals("DEF-V1")) { core.settemplate(ss.GetItem(Lin, splitter, 2), Lin,true); };
                }
                sr.Close(); 
                sr = null;
            }
            if (mymode == "show") {
                txtFrom.Text = data;
                txtTo.Text = data;
                
            }
            if (mymode == "add") {
                this.Text = "Add a Word";
                oneonly();
                
                
            }
            ui.ThemeUi(this);
            splitContainer1.BackColor = ui.ColorNum(-1);
            splitContainer2.BackColor = ui.ColorNum(-1);
            btnRefresh_Click(null, null);
            if (lstItems.Items.Count > 0) lstItems.SelectedIndex = 0;
            lstVars_SelectedIndexChanged(null, null);
        }
        private void oneonly() {
            // reconfigure the form for editing one line
            txtFrom.Visible = false;
            txtTo.Visible = false;
            label2.Visible = false;
            lblOneLine.Visible = true;
            lblOneLine.Text = "Editing one word line....";
            btnRefresh.Visible = false;
            BtnSearch.Visible = false;
               txtSearch.Visible=false;
            lstItems.Visible = false;
            BtnSaveAndClose.Visible = true;
            splitContainer1.SplitterDistance = 0;
        }
        private string GetLine(int i) {
            if (i<0) return "";
            //VbX.MsgBox(i.ToString() + "-" + mydata);
            if (mymode == "file")
            {
                if (srpos > i) {
                    if (sr != null) sr.Close();
                    sr = new System.IO.StreamReader(mydata);
                    srpos=0;
                    
                }
                while (srpos < i && sr.Peek() >= 0)
                {
                    
                    sr.ReadLine(); srpos++;
                }
                srpos++;
                if (sr.Peek() < 0) return "";
             //   VbX.MsgBox(i.ToString() + ".." + srpos.ToString());
                string ln = sr.ReadLine();
                if (ln == "") ln = " ";

                return ln;
            }
            if (mymode == "add")
            {
                if (i > 0) return "";
                return mydata;
            }

            return core.WordArray[i];
        }
        private void SetLine(int i,string lin)
        {
      
            if (mymode == "file")
            {
                if (sr != null) sr.Close();
                System.IO.StreamWriter sw = new System.IO.StreamWriter(mydata + ".new", false, System.Text.Encoding.GetEncoding("utf-8"));
                sr = new System.IO.StreamReader(mydata);
                srpos = 0;
                while (srpos < i && sr.Peek() >= 0) {
                    srpos++;
                    string l = sr.ReadLine();
                    sw.WriteLine(l);
                }
                sr.ReadLine(); // not really needed
                sw.WriteLine(lin);
                srpos++;
                while (sr.Peek() >= 0)
                {
                    srpos++;
                    string l = sr.ReadLine();
                    sw.WriteLine(l);
                }
                
                sw.Close(); sr.Close();
                sr = null; srpos = 9999999999;
                if (System.IO.File.Exists(mydata + ".old")) VbX.Kill(mydata + ".old");
                VbX.Rename(mydata, mydata+".old");
                VbX.Rename(mydata + ".new", mydata);
                return;
            }    

            if (mymode == "add") {
                mydata = lin;
            } else core.WordArray[i]=lin;
            
        }
        private void btnRefresh_Click(object sender, EventArgs e)
        {
            this.SuspendLayout();
            lstItems.Items.Clear();
            liststart = VbX.CInt(txtFrom.Text);
            for (int i = liststart; i <= VbX.CInt(txtTo.Text); i++) {

                string newlin = makeline(i);
                if (newlin == "") { this.ResumeLayout(); return; }
                lstItems.Items.Add(newlin);
                
            }
            this.ResumeLayout();
        }

        private string makeline(int i) {
            string lin = GetLine(i);
            
            if (VbX.nz(lin)=="") return "";
            string splitter = core.GetSplitter(lin);
            string output = "";
            for (int a = skipcols; a <= ss.CountItems(lin, splitter); a++)
            {
                string part = ss.GetItem(lin, splitter, a);
                output += VbX.SafeSub(part.PadRight(30),0, 10) + "  ";

            }
            if (output == "") output = " ";
            return output;
        }
        private void lstItems_SelectedIndexChanged(object sender, EventArgs e)
        {
         if (lstItems.SelectedIndex<0) return;   
            lstVars.Items.Clear();
            txtVar.Clear();
            txtVal.Clear();
            int i=liststart+lstItems.SelectedIndex;

            string lin = GetLine(i);
            txtRealData.Text = lin;
            string splitter = core.GetSplitter(lin);
            string template=core.GetTemplate(ss.GetItem(lin,splitter,2));
            string templatesplitter = core.GetSplitter(template);

            for (int a = skipcols; a <= ss.CountItems(template, templatesplitter); a++)
            {
                string part = ss.GetItem(template, templatesplitter, a);

                lstVars.Items.Add(VbX.SafeSub(part.PadRight(30),0, 10) + "  " + core.GetVar(lin, part));
            }
            
        }

        private void FrmListEditor_Load(object sender, EventArgs e)
        {

        }

        private void lstVars_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (lstItems.SelectedIndex < 0) return;
            if (lstVars.SelectedIndex < 0) return;   
            int i = liststart + lstItems.SelectedIndex;
            string lin = GetLine(i);
            txtRealData.Text = lin;
            string splitter = core.GetSplitter(lin);
            string template = core.GetTemplate(ss.GetItem(lin, splitter, 2));
            string templatesplitter = core.GetSplitter(template);
            int a = lstVars.SelectedIndex + skipcols;
            txtVar.Text  = ss.GetItem(template, templatesplitter, a);
            txtVar.Enabled = false;
            txtVal.Text = core.GetVar(lin, txtVar.Text);
        }

        private void btnSave_Click(object sender, EventArgs e)
        {
            if (txtVar.Text=="") return;
            int i = liststart + lstItems.SelectedIndex;
            string lin = GetLine(i);

            string splitter = core.GetSplitter(lin);
            string template = core.GetTemplate(ss.GetItem(lin, splitter, 2));
            string templatesplitter = core.GetSplitter(template);
            int a = lstVars.SelectedIndex + skipcols;
            lin = core.SetVar(lin, txtVar.Text, txtVal.Text);
            SetLine(i, lin);

            string newlin = makeline(i);
           // VbX.MsgBox(newlin);
            
            lstItems.Items[lstItems.SelectedIndex] = newlin;
            lstItems_SelectedIndexChanged(sender, e);
            
        }

        private void BtnSearch_Click(object sender, EventArgs e)
        {
            if (lstItems.Items.Count < 0) return;
            for (int i = liststart + lstItems.SelectedIndex+1; i < VbX.CInt(txtTo.Text); i++)
            {

                string newlin = GetLine(i);
                if (newlin != null)
                {
                    if (newlin.ToLower().Contains(txtSearch.Text.ToLower()))
                    {

                        lstItems.SetSelected(i - liststart, true);
                        return;
                    }
                }
                

            }
            VbX.MsgBox(ui.GetTrans("NotFound","Not Found",false));
        }

        private void BtnSaveAndClose_Click(object sender, EventArgs e)
        {
            btnSave_Click(null, null);
            if (mymode == "add")
            {
                core.MaxData = core.MaxData + 1;

                core.WordArray[core.MaxData] = mydata;
            }

            Close();
        }

        private void FrmListEditor_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (sr != null) sr.Close();
                    
        }
    }
}

