﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace BenkyouStudio
{
    public partial class FrmFileConverter : Form
    {
        public FrmFileConverter()
        {
            InitializeComponent();
            CboSrcEncoding.Font = new Font(FontFamily.GenericMonospace,8);
            CboDestEncoding.Font=CboSrcEncoding.Font;
            txtPreview.Font = CboSrcEncoding.Font;
            foreach (System.Text.EncodingInfo i in System.Text.Encoding.GetEncodings()) {
                
                CboSrcEncoding.Items.Add(i.GetEncoding().EncodingName.ToString().PadRight(30).Substring(0,29)+" "+i.GetEncoding().WebName.ToString());
                CboDestEncoding.Items.Add(i.GetEncoding().EncodingName.ToString().PadRight(30).Substring(0,29)+" "+i.GetEncoding().WebName.ToString());
            
            }
            ui.ThemeUi(this);
        }

        private void TxtSrcFile_DragDrop(object sender, DragEventArgs e)
        {
            string[] Droppedfiles = (string[])e.Data.GetData(DataFormats.FileDrop, false);
            TxtSrcFile.Text = Droppedfiles[0];
        }

        private void TxtSrcFile_DragEnter(object sender, DragEventArgs e)
        {
            e.Effect = DragDropEffects.Link;
        }

        private void TxtDestFile_DragDrop(object sender, DragEventArgs e)
        {
            string[] Droppedfiles = (string[])e.Data.GetData(DataFormats.FileDrop, false);
            TxtDestFile.Text = Droppedfiles[0];
        }

        private void TxtDestFile_DragEnter(object sender, DragEventArgs e)
        {
            e.Effect = DragDropEffects.Link;
        }

        private void btnPreview_Click(object sender, EventArgs e)
        {
            
            System.IO.StreamReader sr ;
               System.Text.Encoding enc = null;
            if (CboSrcEncoding.Text.Length > 0)
            {
             
                enc = System.Text.Encoding.GetEncoding(CboSrcEncoding.Text.Substring(30));
                sr = new System.IO.StreamReader(TxtSrcFile.Text, enc);
            }
            else
            {
                sr = new System.IO.StreamReader(TxtSrcFile.Text);
            }
            txtPreview.Text="";
            int linect = 0;
            while (linect < VbX.CInt(txtPreviewFrom.Text) && sr.Peek() >= 0)
            {
                
                sr.ReadLine();
                
                linect++;
            }
            linect = 0;
            while (linect<VbX.CInt(txtPreviewLines.Text) && sr.Peek()>=0){
                string lin=sr.ReadLine();
                txtPreview.Text = txtPreview.Text +lin+(char)13+(char)10;
                linect++;
            };
            sr.Close();

        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show("Save File","?",MessageBoxButtons.YesNo)!=DialogResult.Yes) return;

            System.IO.StreamReader sr;
            System.IO.StreamWriter sw;
            System.Text.Encoding encr = null;
            System.Text.Encoding encw = null;
            if (CboSrcEncoding.Text.Length > 0)
            {  encr = System.Text.Encoding.GetEncoding(CboSrcEncoding.Text.Substring(30));
                sr = new System.IO.StreamReader(TxtSrcFile.Text, encr);}
            else sr = new System.IO.StreamReader(TxtSrcFile.Text);
        
        
         if (CboDestEncoding.Text.Length > 0)
            {  encw = System.Text.Encoding.GetEncoding(CboDestEncoding.Text.Substring(30));
                sw = new System.IO.StreamWriter(TxtDestFile.Text,false, encw);}
            else sw = new System.IO.StreamWriter(TxtDestFile.Text,false);
        
            int linect = 0;
            while (  sr.Peek() >= 0)
            {
                string lin = sr.ReadLine();
                sw.WriteLine(lin);
                linect++;
            };
            sw.Close();
            sr.Close();
            MessageBox.Show(linect.ToString() + " Lines saved", "!");
        }


        private void btnSelectFile_Click(object sender, EventArgs e)
        {   OpenFileDialog fd = new OpenFileDialog();
            fd.Filter = "All files (*.*)|*.*" ;
            DialogResult dr= fd.ShowDialog();
            if (dr == DialogResult.OK) TxtSrcFile.Text=fd.FileName;
         }

        private void btnSelectDestFile_Click(object sender, EventArgs e)
        {
            SaveFileDialog fd = new SaveFileDialog();
            fd.Filter = "All files (*.*)|*.*";
            DialogResult dr = fd.ShowDialog();
            if (dr == DialogResult.OK) TxtDestFile.Text = fd.FileName;
        }


    }
}
