﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace BenkyouStudio
{
    public partial class FrmCharacterMap : Form
    {
        public FrmCharacterMap()
        {
            InitializeComponent();
            txtCharacterMap.Font = new Font(FontFamily.GenericMonospace, 8);
            cboPreDef.Items.Add("ascii");
            cboPreDef.Items.Add("jpn-kana");
            cboPreDef.Items.Add("jpn-BigAndSmallFonts");
            cboPreDef.Items.Add("kor");
            ui.ThemeUi(this);
            cboShowMode.Items.Add("Decimal");
            cboShowMode.Items.Add("Hex");
            cboShowMode.Items.Add("None");
            cboShowMode.DropDownStyle = ComboBoxStyle.DropDownList;
            
        }

        

        private void btnRefresh_Click(object sender, EventArgs e)
        {
            string nl = Environment.NewLine;
            string typ = "";
            int from = 32;
            int to = 128;

            if (cboShowMode.Text.ToLower()=="hex") typ = "x";

            if (chkInputHex.Checked)
            {
                from=Convert.ToInt32(txtFrom.Text, 16);
                to = Convert.ToInt32(txtTo.Text, 16);
            }
            else {
                from = VbX.CInt(txtFrom.Text);
                to = VbX.CInt(txtTo.Text);
            }

            int spacer = VbX.CInt(to).ToString(typ).Length;
            string lin = "";
            int count = 0;
            if (chkHtml.Checked) {
                lin += "<html><head>" + nl;
                lin += "<style>" + nl;
                lin += ".dgt{" + nl;
                lin += "color=#FF0000" + nl;
                lin += "}" + nl;
                lin += "</style>" + nl; 
                lin += "</head><body><table>"+nl; 
            }
                 lin += VbX.Chr(13) + VbX.Chr(10);
            for (int i = from; i <= to; i++) {
                count++;
                if (count==1 && chkHtml.Checked) lin += "<tr>";
                string part = "";
                   if (chkHtml.Checked) {
                       
                       string bit = "&#x" + i.ToString("x") + ";";
                       if (core.ChrSafe(i)==" ") bit="&nbsp;";
                       if (cboShowMode.Text.ToLower()!="none") part = "<td class=dgt>" + i.ToString(typ) + "</td>";
                       part=part+"<td>"+bit+"</td>";
                   } else {
                       if (cboShowMode.Text.ToLower() != "none") part = VbX.Right(i.ToString(typ).PadLeft(8), spacer) + " ";
                        part += core.ChrSafe(i)+ "  " ;
                   }
                lin += part;
                if (count == VbX.CInt(cboCharsPerLine.Text))
                {
                    count = 0;
                    if (chkHtml.Checked) lin+="</tr>";
                    lin += VbX.Chr(13) + VbX.Chr(10);
                    
                }
            }
            if (chkHtml.Checked) lin+="</table></body></html>";
            txtCharacterMap.Text = lin;
        }

        private void comboBox2_SelectedIndexChanged(object sender, EventArgs e)
        {
            chkInputHex.Checked = false;
            switch (cboPreDef.Text.ToLower()) {
                case "ascii":
                    txtFrom.Text = "0";
                    txtTo.Text = "255";
                    break;
                case "jpn-kana":
                    txtFrom.Text = "12353";
                    txtTo.Text = "12799";
                    break;
                case "jpn-BigAndSmallFonts":
                    txtFrom.Text = "65281";
                    txtTo.Text = "65439";
                    break;
                    
                case "kor":
                    txtFrom.Text = "44032";
                    txtTo.Text = "55203";
                    break;
            }
        }
        
    }
}
