﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;


namespace BenkyouStudio
{
    public partial class FrmBmpBuilder : Form
    {
        public FrmBmpBuilder()
        {
            InitializeComponent();
            foreach (FontFamily f in System.Drawing.FontFamily.Families)
            {
                cboFont.Items.Add(f.Name);
                cboFont2.Items.Add(f.Name);
                cboFont3.Items.Add(f.Name);
                cboFont4.Items.Add(f.Name);

            }
            TxtInfo.Text= "Please see:" + Environment.NewLine + "http://nehe.gamedev.net/tutorial/2d_texture_font/18002/" + Environment.NewLine + "for a tutorial on using this kind of font";
            CalcSize();
            ui.ThemeUi(this);
            
            this.pictureBox1.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(192)))), ((int)(((byte)(255)))), ((int)(((byte)(255)))));
        }
        private void CalcSize() {
            string lin = (Convert.ToInt16(txtSizeX.Text) * Convert.ToInt16(txtCellsX.Text)).ToString();
            lin += " x ";
            lin += (Convert.ToInt16(txtSizeY.Text) * Convert.ToInt16(txtCellsY.Text)).ToString();
            lin += " pixels / ";
            lin += (Convert.ToInt16(txtCellsX.Text) * Convert.ToInt16(txtCellsY.Text)).ToString()+" Chars per tile";
            lblImageSize.Text = lin;

        
        }
        private void button1_Click(object sender, EventArgs e)
        {
            
            int xnum = Convert.ToInt16(txtCellsX.Text);
            int ynum = Convert.ToInt16(txtCellsY.Text);
            int cellw = Convert.ToInt16(txtSizeX.Text);
            int cellh = Convert.ToInt16(txtSizeY.Text);
            int border = 2;
            int wid =cellw*xnum;
            int hei = cellh*ynum;
            int ch=32;
            int startnum=-1;
            int endnum=-1;
            int panel = 0;
            bool done = false;
            string jobstring = txtDataRange.Text;
            int jobpos = -1;
            int font = 1;
            System.Drawing.Font fnt = new Font(cboFont.Text, Convert.ToInt16(txtFontSize.Text), FontStyle.Regular);
            SolidBrush brufore = new SolidBrush(Color.White);
            
            brufore = new SolidBrush(System.Drawing.ColorTranslator.FromHtml("#"+fontfore.Text));
            SolidBrush bruback = new SolidBrush(System.Drawing.ColorTranslator.FromHtml("#" + fontback.Text));
            System.Drawing.Bitmap img = new Bitmap(wid, hei);
            System.Drawing.Bitmap cell = new Bitmap(cellw,cellh);
            string csv = "";
            System.Drawing.Graphics g=System.Drawing.Graphics.FromImage(cell);
            System.Drawing.Graphics g2=System.Drawing.Graphics.FromImage(img);
            if (chkAntiAlias.Checked == true)
            {
                g.TextRenderingHint = System.Drawing.Text.TextRenderingHint.AntiAlias;

            }
            else
            {

                g.TextRenderingHint = System.Drawing.Text.TextRenderingHint.SingleBitPerPixelGridFit;
            }
            csv +="font,unicode,tile,sprite,xpos,ypos" + Environment.NewLine;
                      
                      
            while (!done)
            {
                g2.Clear(Color.FromArgb(0, 255, 0, 255));
                for (int y = 0; y < ynum; y++)
                {
                    for (int x = 0; x < xnum; x++)
                    {
                        
                            if (startnum == -1) {
                                

                                string thisjob = "newjob";
                                    while (thisjob=="newjob"){
                                        jobpos++;
                                        thisjob=ss.GetItem(jobstring, ";", jobpos);
                                        if (thisjob.ToLower() == "font1") { fnt = new Font( cboFont.Text, Convert.ToInt16(txtFontSize.Text), FontStyle.Regular); 
                                            thisjob = "newjob"; font = 1;
                                            brufore = new SolidBrush(System.Drawing.ColorTranslator.FromHtml("#" + fontfore.Text));
                                            bruback = new SolidBrush(System.Drawing.ColorTranslator.FromHtml("#" + fontback.Text));
                                        }
                                        if (thisjob.ToLower() == "font2")
                                        {
                                            fnt = new Font(  cboFont2.Text, Convert.ToInt16(txtFontSize2.Text), FontStyle.Regular);
                                            thisjob = "newjob"; font = 2;
                                            brufore = new SolidBrush(System.Drawing.ColorTranslator.FromHtml("#" + fontfore2.Text));
                                            bruback = new SolidBrush(System.Drawing.ColorTranslator.FromHtml("#" + fontback2.Text));
                                        }
                                        if (thisjob.ToLower() == "font3")
                                        {
                                            fnt = new Font(  cboFont3.Text, Convert.ToInt16(txtFontSize3.Text), FontStyle.Regular);
                                            thisjob = "newjob"; font = 3;
                                            brufore = new SolidBrush(System.Drawing.ColorTranslator.FromHtml("#" + fontfore3.Text));
                                            bruback = new SolidBrush(System.Drawing.ColorTranslator.FromHtml("#" + fontback3.Text));
                                        }
                                        if (thisjob.ToLower() == "font4")
                                        {
                                            fnt = new Font(
                                                cboFont4.Text, Convert.ToInt16(txtFontSize4.Text), FontStyle.Regular);
                                            thisjob = "newjob"; font = 4;
                                            brufore = new SolidBrush(System.Drawing.ColorTranslator.FromHtml("#" + fontfore4.Text));
                                            bruback = new SolidBrush(System.Drawing.ColorTranslator.FromHtml("#" + fontback4.Text));
                                        }
                                    }
                                
                                if (thisjob.Length > 0)
                                {
                                    
                                    startnum = VbX.CInt(ss.GetItem(thisjob, "-", 0));
                                    ch = startnum;
                                    endnum = VbX.CInt(ss.GetItem(thisjob, "-", 1));
                                    
                                }
                                else done = true;
                            }
                            
                        g.Clear(Color.FromArgb(0, 255, 0, 255));
                        //g.FillRectangle(new SolidBrush(Color.FromArgb(0, 255, 0, 255)), 0, 0, cellw , cellh);                 
                        if (ch > -1)
                        {
                            // check this char is safe to try to draw
                            if (core.ChrSafe(ch) != " ")
                            {
                                for (int bx = -border; bx <= border; bx++)
                                    for (int by = -border; by <= border; by++)
                                        g.DrawString(((char)ch).ToString(), fnt, bruback, bx, by);

                                g.DrawString(((char)ch).ToString(), fnt, brufore, 0, 0);

                                if (chkVivid.Checked == true) g.DrawString(((char)ch).ToString(), fnt, brufore, 0, 0);
                            }
                            int cpos = x + y * xnum;
                            csv += font.ToString() + "," + ch.ToString() + "," + panel.ToString() + "," + cpos.ToString() + "," + x.ToString() + "," + y.ToString() + Environment.NewLine;
                            g2.DrawImage(cell, x * (wid / xnum), y * (hei / ynum));

                            ch++;
                        }
                        if (ch > endnum) { ch = -1; startnum = -1; endnum = -1; }
                    }
        
                }
                pictureBox1.Image = img;
                this.Refresh();
                
                if (panel <10) System.Threading.Thread.Sleep(500);
                img.Save(txtDest.Text + VbX.Right("00000000" + panel.ToString(), 4) + ".png");
                panel++;
                
            }
            TxtInfo.Text = csv;
          if (panel>10)  VbX.MsgBox(ui.GetTrans("ExportsDone","Exports done!",false));
        }
        private void label2_Click(object sender, EventArgs e)
        {

        }

        private void txtCellsX_TextChanged(object sender, EventArgs e)
        {
            CalcSize();
        }

        private void txtCellsY_TextChanged(object sender, EventArgs e)
        {
            CalcSize();
        }

        private void txtSizeX_TextChanged(object sender, EventArgs e)
        {
            CalcSize();
        }

        private void txtSizeY_TextChanged(object sender, EventArgs e)
        {
            CalcSize();
        }

        private void chkAntiAlias_CheckedChanged(object sender, EventArgs e)
        {
            if (chkAntiAlias.Checked == true) chkVivid.Enabled = true; else chkVivid.Enabled = false;
        }

        private void button1_Click_1(object sender, EventArgs e)
        {
            SaveFileDialog fd = new SaveFileDialog();
            fd.Filter = "All files (*)|*";
            DialogResult dr = fd.ShowDialog();
            if (dr == DialogResult.OK) txtDest.Text = fd.FileName;
        }

        private void txtDest_TextChanged(object sender, EventArgs e)
        {

        }

        private void txtDataRange_TextChanged(object sender, EventArgs e)
        {

        }
    }
}
