
#import "GLSpriteAppDelegate.h"
#import "EAGLView.h"

@implementation GLSpriteAppDelegate

@synthesize window;

// Sets up the frame rate and starts animating the sprite.
- (void)applicationDidFinishLaunching:(UIApplication *)application {
	//application = application;
	// Look in the Info.plist file and you'll see the status bar is hidden
	// Set the style to black so it matches the background of the application
	[application setStatusBarStyle:UIStatusBarStyleBlackTranslucent animated:NO];
	// Now show the status bar, but animate to the style.
	[application setStatusBarHidden:NO animated:YES];
	glView.animationInterval = 1.0 / 60.0;
	[glView startAnimation];


}
- (void)applicationDidReceiveMemoryWarning:(UIApplication *)application {
	[glView purge];
	//glView.animationInterval = 1.0 / 5.0;
}
- (void)applicationWillTerminate:(UIApplication *)application {
    // Store user's time signature preference, so that it is used the next time the app is launched
  [glView Quit];
}


// Changes the frame rate when the application is about to be inactive.
- (void)applicationWillResignActive:(UIApplication *)application {
	NSLog(@"applicationWillResignActive:");
	glView.animationInterval = 1.0 / 5.0;
}

// Resumes the initial frame rate when the application becomes active.
- (void)applicationDidBecomeActive:(UIApplication *)application {
	NSLog(@"applicationDidBecomeActive:");
	glView.animationInterval = 1.0 / 60.0;
}

// Stops the animation and then releases the window resource.
- (void)dealloc {
	[glView stopAnimation];
	[glView release];
	[window release];
	[super dealloc];
} 



@end
