//
//  IPCoreSpriteObj.m
//  GLSprite
//
//  Created by David Austin on 09/05/2009.
//  Copyright 2009 David Austin Roses Ltd. All rights reserved.
//

#import "IPCoreSpriteObj.h"
const float PixPerUnitX = 160;
const float PixPerUnitY = 160;

@implementation IPCoreSpriteObj
-(void)LoadSprite:(NSString *)spritename{
	Frame=0;
	Frames=0;
	LoadedSprite=YES;
	mysprite = [IPCoreSprite alloc];
	[mysprite LoadSprite:spritename];
	Wid= (float)mysprite->ResX/PixPerUnitX;
	Hei= (float)mysprite->ResY/PixPerUnitY;
}
-(void)LoadPvrSprite:(NSString *)spritename{
	Frame=0;
	Frames=0;
	LoadedSprite=YES;
	mysprite = [IPCoreSprite alloc];
	[mysprite LoadPvrSprite:spritename];
	Wid= (float)mysprite->ResX/PixPerUnitX;
	Hei= (float)mysprite->ResY/PixPerUnitY;
}
-(void)DoAnimate{
	if (AnimMoveSpeedX>0 || AnimMoveSpeedY>0)
	{
		if (AnimMoveSpeedX>0 && Xpos<AnimMoveEndX &&Xpos+AnimMoveSpeedX<AnimMoveEndX) Xpos+=AnimMoveSpeedX;
		else if (AnimMoveSpeedX>0 && Xpos>AnimMoveEndX && Xpos-AnimMoveSpeedX>AnimMoveEndX) Xpos-=AnimMoveSpeedX;
		else {
			Xpos=AnimMoveEndX;
			AnimMoveSpeedX=0;
		}
		if (AnimMoveSpeedY>0 && Ypos<AnimMoveEndY && Ypos+AnimMoveSpeedY<AnimMoveEndY) Ypos+=AnimMoveSpeedY;
		else if (AnimMoveSpeedY>0 && Ypos>AnimMoveEndY &&Ypos-AnimMoveSpeedY>AnimMoveEndY) Ypos-=AnimMoveSpeedY;
		else {
			Ypos=AnimMoveEndY;
			AnimMoveSpeedY=0;
		}
	}
	
	
	
	if (AnimRotating!=0){
		if (AnimRotatingTime>0) AnimRotatingTime--;
			
		if (AnimRotatingTime!=0){
			Rot+=AnimRotating;
			if (Rot<0)  Rot+=360;
			if (Rot>360) Rot-=360;
		}
		
	}
	if (AnimFading!=0){
		Alp+=AnimFading;
		if (Alp<0) Alp=0;
		if (Alp>1) Alp=1;
	}
	if (AnimScalingTime>0)
	{
		Wid+=AnimScalingX;
		Hei+=AnimScalingY;
		AnimScalingTime--;
	}

	//Frame animation
	if (AnimFrameStep!=0)
	{
		if(AnimFrameTime>0){
			AnimFrameTime--;
		}
		
		
		if (((Frame>=AnimFrameTo || Frame+AnimFrameStep>AnimFrameTo ) && AnimFrameStep>0) ||((Frame<=AnimFrameTo || Frame+AnimFrameStep<AnimFrameTo ) && AnimFrameStep<0))	Frame=AnimFrameFrom;
		else Frame+=AnimFrameStep;
		
	}
}
-(void)DrawOnly{
	
	
	
	if (Alp>0){
		if (Alp<1) glColor4f(1,1,1, Alp);
		if (Frames==0){
			[mysprite DrawSpriteX:Xpos Y:Ypos W:Wid H:Hei R:Rot];
			
		} else{
			
			int fr=Frame;
			[mysprite DrawAniSpriteX:Xpos Y:Ypos W:Wid H:Hei R:Rot F:fr Flip:FlipMe];
			
		}
		if (Alp<1) glColor4f(1,1,1, 1);
	}
	
}
-(void)DrawSprite{
	
	[self DrawOnly];
	[self DoAnimate];
};	
-(void)FrameTo:(float)f{AnimFrameStep=0;AnimFrameTime=-1;;Frame=f;}
-(void)AnimFramesFrom:(float)f To:(float)t Step:(float)s{AnimFrameFrom=f;AnimFrameTo=t;AnimFrameStep=s;Frame=f;AnimFrameTime=-1;}
-(void)FadeTo:(float)a{Alp=a;AnimFading=0;}
-(void)DefineTileX:(int)Xsize Y:(int)Ysize{
	[mysprite DefineTileX:Xsize Y:Ysize];
	Frames=Xsize*Ysize-1;
	Frame=0;
	Wid= ((float)mysprite->ResX/Xsize)/PixPerUnitX;
	Hei= ((float)mysprite->ResY/Ysize)/PixPerUnitY;
}
-(void)ResetSize{	Wid= ((float)mysprite->ResX/mysprite->TileX)/PixPerUnitX;
Hei= ((float)mysprite->ResY/mysprite->TileY)/PixPerUnitY;
	AnimScalingX=0;
	AnimScalingY=0;
	AnimScalingTime=0;
}

-(void)MovetoX:(float)x Y:(float)y{
	Xpos=x;
	Ypos=y;
	AnimMoveEndX=0;
	AnimMoveEndY=0;
	AnimMoveSpeedX=0;
	AnimMoveSpeedY=0;

}
-(void)MovetoX:(float)x{Xpos=x;}
-(void)MovetoY:(float)y{Ypos=y;}
-(void)RotateTo:(float)r{Rot=r;AnimRotating=0;AnimRotatingTime=-1;}
-(void)AnimRotate:(float)r{AnimRotating=r;AnimRotatingTime=-1;}
-(void)AnimFade:(float)a{AnimFading=a;}
-(BOOL)IsTouchedX:(float)x Y:(float)y ObjX:(float)ObjX ObjY:(float)ObjY ObjW:(float)ObjW ObjH:(float)ObjH {
	if (x>=(ObjX-ObjW/2) && x<=(ObjX+ ObjW/2) && y>=(ObjY-ObjH/2) && y<=(ObjY+ObjH/2)) return YES; else return NO;
}

-(BOOL)IsTouchedX:(float)x Y:(float)y{
	if (x>=(Xpos-Wid/2) && x<=(Xpos+ Wid/2) && y>=(Ypos-Hei/2) && y<=(Ypos+Hei/2)) return YES; else return NO;
}
-(void)init{
	LoadedSprite=NO;
	AnimRotatingTime=-1;
	AnimScalingTime=-1;
	Wid=1;
	Hei=1;
	Xpos=0;
	Ypos=0;
	Rot=0;
	Alp=1;
	AnimRotating=0;
	[super init];
}
-(void)dealloc{
	if (LoadedSprite) [mysprite dealloc];
	[super dealloc];
}
-(void)SizeToW:(float)w H:(float)h{Wid=w;Hei=h;}
-(void)AnimMovetoX:(float)x Y:(float)y S:(float)spd{
float dist=(abs((Xpos-x)*10000))+(abs((Ypos-y)*10000));
	if (dist>0){
	AnimMoveEndX=x;
	AnimMoveEndY=y;
	AnimMoveSpeedX=((abs((Xpos-x)*10000))*spd)/dist;
	AnimMoveSpeedY=((abs((Ypos-y)*10000))*spd)/dist;
	}
}
-(BOOL)Intersects:(IPCoreSpriteObj *)sprite2 TolW:(float)tolw TolH:(float)tolh
{

	if (  ((Xpos>=sprite2->Xpos-(sprite2->Wid/(2*tolw))) && (Xpos<=sprite2->Xpos+(sprite2->Wid/(2*tolw))))
	&&  ((Ypos>=sprite2->Ypos-(sprite2->Hei/(2*tolh))) && (Ypos<=sprite2->Ypos+(sprite2->Hei/(2*tolh))))
	)	return YES;
	else 	if (  ((sprite2->Xpos>=Xpos-Wid/(2*tolw)) && (sprite2->Xpos<=Xpos+Wid/(2*tolw)))
				&&  ((sprite2->Ypos>=Ypos-Hei/(2*tolh)) && (sprite2->Ypos<=Ypos+Hei/(2*tolh)))
				)	return YES;
	//(Xpos+(Wid/2)>=sprite2->Xpos-(sprite2->Wid/2)) && (Xpos+(Wid/2)<=sprite2->Xpos+(sprite2->Wid/2))
	//	return YES;
	return NO;
}
-(void)ShareSprite:(IPCoreSpriteObj *)sprite2{
	mysprite=sprite2->mysprite;
	[self DefineTileX:sprite2->mysprite->TileX Y:sprite2->mysprite->TileY];
	[self CopyAttributes:sprite2];
	[self CopyAnim:sprite2];
}

-(void)CopyAttributes:(IPCoreSpriteObj *)sprite2{
	Wid=sprite2->Wid;
	Hei=sprite2->Hei;
	Xpos=sprite2->Xpos;
	Ypos=sprite2->Ypos;
	Rot=sprite2->Rot;
	Alp=sprite2->Alp;
}
-(void)CopyAnim:(IPCoreSpriteObj *)sprite2{
	AnimFrameStep=sprite2->AnimFrameStep;
	AnimFrameFrom=sprite2->AnimFrameFrom;
	AnimFrameTo=sprite2->AnimFrameTo;
	AnimFrameTime=sprite2->AnimFrameTime;
	AnimRotatingTime=sprite2->AnimRotatingTime;
	AnimRotating=sprite2->AnimRotating;
}
-(void)AnimScaleX:(float)x Y:(float)y T:(float)ti{
	AnimScalingX=x;
	AnimScalingY=y;
	AnimScalingTime=ti;
}
-(void)AnimRotateTo:(float)r S:(float)speed{
	
	//float movesize;
	
	if (r<Rot && (Rot-r)<=180)  {
		AnimRotatingTime=(Rot-r)/speed;
		AnimRotating=-speed;
	} else if (Rot<r && (r-Rot)<=180)  {
		AnimRotatingTime=(r-Rot)/speed;
		AnimRotating=speed;
	} else if (r<Rot && (Rot-r)>180)  {
		AnimRotatingTime=((360-Rot)-r)/speed;
		AnimRotating=speed;
	} else if (Rot<r && (r-Rot)>180)  {
		AnimRotatingTime=((360-r)-Rot)/speed;
		AnimRotating=-speed;
	}
};
@end
