//
//  IPCoreDynSprite.m
//  GLSprite
//
//  Created by David Austin on 11/05/2009.
//  Copyright 2009 David Austin Roses Ltd. All rights reserved.
//

#import "IPCoreDynSprite.h"

@implementation IPCoreDynSprite
-(void)CreateBlankWid:(float)wid Hei:(float)hei
{
	//spriteData = (GLubyte *) malloc(wid* hei * 4);
	// Uses the bitmatp creation function provided by the Core Graphics framework. 
	
	//spriteContext = CGBitmapContextCreate(spriteData, wid, hei, 8, wid* 4,,kCGImageAlphaPremultipliedLast);
	// After you create the context, you can draw the sprite image to the context.
	//CGContextClearRect(spriteContext,CGRectMake(0.0, 0.0, (CGFloat)wid, (CGFloat)hei));
	// You don't need the context at this point, so you need to release it to avoid memory leaks.
	//CGContextRelease(spriteContext);
	//RGBIMG img = {wid,hei,NULL}; //w*h
	long data_size = 4 * sizeof(GLubyte) * wid * hei;
	SpriteData= (GLubyte*) malloc(data_size);
	for (int i=0; i < (int)(wid*hei); i++) {
		
		//*(g_pPixelBuffer+0+(i*4))=0; // it's always true so let's hard code it.
		SpriteData[0+(i*4)]=0;
		SpriteData[1+(i*4)]=0;
		SpriteData[2+(i*4)]=0;
		SpriteData[3+(i*4)]=0;
	}
	mysprite=[[IPCoreSprite alloc] init];

	mysprite->ResX=wid;
	mysprite->ResY=hei;
	mysprite->inuse=YES;
	// Use OpenGL ES to generate a name for the texture.
	glGenTextures(1, &mysprite->spriteTexture);
	// Bind the texture name. 
	glBindTexture(GL_TEXTURE_2D, mysprite->spriteTexture);
	// Speidfy a 2D texture image, provideing the a pointer to the image data in memory
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, wid, hei, 0, GL_RGBA, GL_UNSIGNED_BYTE, SpriteData);
	// Release the image data
	//free(img.data);
	//free(spriteData);
	
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);	// Set Texture Max Filter
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);	// Set Texture Min Filter
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S,GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T,GL_REPEAT);
	// Enable use of the texture
	glEnable(GL_TEXTURE_2D);
	

}
-(void)FillX:(int)x Y:(int)y W:(int)w H:(int)h R:(Byte)r G:(Byte)g B:(Byte)b A:(Byte)a{
//	BOOL Cando=YES;
	if (y>=0 &&x >=0 &&(y+h)<mysprite->ResY && (x+w)<mysprite->ResX)
	{
	
	int xs=mysprite->ResX;
	for (int px=x;px<x+w;px++)
			for (int py=y;py<y+h;py++)
			{
				int i=px+(py*xs);
				SpriteData[(i*4)]=r;
				SpriteData[1+(i*4)]=g;
				SpriteData[2+(i*4)]=b;
				SpriteData[3+(i*4)]=a;
			
			}
	}
}
-(void)FadeAX:(int)x Y:(int)y W:(int)w H:(int)h{
	if (y>=0 &&x >=0 &&(y+h)<=mysprite->ResY && (x+w)<=mysprite->ResX)
	{
		
		int xs=mysprite->ResX;
		for (int px=x;px<x+w;px++)
			for (int py=y;py<y+h;py++)
			{
				int i=px+(py*xs);
		
				if (SpriteData[3+(i*4)]>10) SpriteData[3+(i*4)]-=10; else SpriteData[3+(i*4)]=0;
		}
	}
	

} 
	-(void)Refresh {
	
		glBindTexture(GL_TEXTURE_2D, mysprite->spriteTexture);
		// Speidfy a 2D texture image, provideing the a pointer to the image data in memory
		glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, mysprite->ResX, mysprite->ResY, 0, GL_RGBA, GL_UNSIGNED_BYTE, SpriteData);
		
	}
- (void)dealloc {
	free(SpriteData);
	//[SpriteData release]; //problem
	[mysprite release];
		free (SpriteData);
	[super dealloc];
}

@end
