#define kAccelerometerFrequency		100.0 // Hz
#define kFilteringFactor			0.1

//const int GameTitle=1;
//const int GamePlay=2;
#import <UIKit/UIKit.h>
#import <OpenGLES/EAGL.h>
#import <OpenGLES/ES1/gl.h>
#import <OpenGLES/ES1/glext.h>
#import "IPCoreSound.h"
#import "IPCoreSprite.h"
#import "IPCoreDynSprite.h"
#import "IPCoreSpriteObj.h"
#import "IPCoreSetting.h"
//@protocol GLGravityViewDelegate;
@interface EAGLView : UIView <UIAccelerometerDelegate>
{
@private
	//id<GLGravityViewDelegate> delegate;
	BOOL delegateSetup;
	/* The pixel dimensions of the backbuffer */
	GLint backingWidth;
	GLint backingHeight;
	//IPCoreSetting *settings;
	EAGLContext *context;
	
	/* OpenGL names for the renderbuffer and framebuffers used to render to this view */
	GLuint viewRenderbuffer, viewFramebuffer;
	
	/* OpenGL name for the depth buffer that is attached to viewFramebuffer, if it exists (0 if it does not exist) */
	GLuint depthRenderbuffer;
	
	/* OpenGL name for the sprite texture */
	//GLuint spriteTexture;
	IPCoreSpriteObj *StarField;
	IPCoreSpriteObj *TouchSpot;
	IPCoreSpriteObj *MoveTarget;
	IPCoreSpriteObj *TeleportTarget;
	IPCoreSpriteObj *Ball;
	IPCoreSpriteObj *ShipG;
	IPCoreSpriteObj *ShipGTeleporting;
	IPCoreSpriteObj *ShipR;
	IPCoreSpriteObj *ShipRTeleporting;
	IPCoreSpriteObj *Sat1;
	IPCoreSpriteObj *Sat2;
	IPCoreSpriteObj *Sat3;
	IPCoreSpriteObj *Sat4;
	
	
	IPCoreSound *asteroidball;
	IPCoreSound *asteroidship;
	IPCoreSound *powerup;
	
	int astcount;
	IPCoreSpriteObj *Asteroid[8];
	
	IPCoreSpriteObj *Backdrop;
	IPCoreSpriteObj *Powerups;
	IPCoreSpriteObj *PowerupsActive;
	IPCoreSpriteObj *sparks;
	IPCoreDynSprite *FX;
	IPCoreSound *bounce;
	IPCoreSound *shock;
	IPCoreSound *teleport;
	IPCoreSound *alarm;
	IPCoreSound *music;
	IPCoreSpriteObj *PUship;
	IPCoreSprite *myfont;
	IPCoreSprite *burst;
	IPCoreSprite *MenuTarget;
	IPCoreSprite *ForceField;
	int GameNum;
	int RoundNum;
	//int RoundTime;
	int Gscore;
	int Rscore;
	int PUtime;
	int PUtype;
	//int frameno;
	int CpuWait;
	int Ticks;
	float PUtextSize;
	int RoundTime;
	int AiLevel;
	int Score;
	int HiScore;
	int GameState;
	int GameStateTime;
	float ForcePos; // Position of the forcefield beams
	int ffstate;
	float ffstatetime;
	float AccelX;
	float AccelY;
	float AccelXzero;
	float AccelYzero;
	float TouchStartX;
	float TouchStartY;
	float TouchLastX;
	float TouchLastY;
	int TouchTime;
	BOOL ispaused;
	//int poweruptype;
	NSTimer *animationTimer;
	NSTimeInterval animationInterval;
}
//@property(nonatomic, assign) id<GLGravityViewDelegate> delegate;

-(void)Bounce:(IPCoreSpriteObj*)sone Off:(IPCoreSpriteObj*)stwo;
- (void)TimerTick;
- (void)startAnimation;
- (void)stopAnimation;
- (void)drawMenu;
- (void)AnimateGame;
- (void)drawView;
- (void)NewRound:(BOOL)showships;
- (void)EndRound;
- (void)initpowerup;
- (void) DoPowerup:(IPCoreSpriteObj*)Ship ;
- (void) ClearPowerup;
- (void)drawScore;
- (void)drawHelp;
-(void)drawPaused;
- (void)RoundInc;
- (void)Quit;
-(void)DoSetting:(BOOL)save;
-(void)DoSettingSprite:(IPCoreSpriteObj*)Sprite Sname:(NSString *)Sname Write:(BOOL)save;
//-(id<GLGravityViewDelegate>)delegate;
//-(void)setDelegate:(id<GLGravityViewDelegate>)d;
@property NSTimeInterval animationInterval;

@end

//@protocol GLGravityViewDelegate<NSObject>

//@required


//@optional



//@end